<?php
/**
 * Template para posts individuales
 *
 * @package UNSM_Theme
 */

get_header(); ?>

<main id="main-content" class="single-post-content">
    <?php
    while ( have_posts() ) :
        the_post();
        ?>

        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            <!-- Imagen destacada -->
            <?php if ( has_post_thumbnail() ) : ?>
                <div class="post-featured-image">
                    <?php the_post_thumbnail( 'large', array( 'alt' => get_the_title() ) ); ?>
                </div>
            <?php endif; ?>

            <div class="post-container">
                <!-- Cabecera del post -->
                <header class="post-header">
                    <?php
                    // Mostrar categorías
                    $categories = get_the_category();
                    if ( ! empty( $categories ) ) :
                        ?>
                        <div class="post-categories">
                            <?php foreach ( $categories as $category ) : ?>
                                <span class="post-category"><?php echo esc_html( $category->name ); ?></span>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>

                    <h1 class="post-title"><?php the_title(); ?></h1>

                    <div class="post-meta">
                        <span class="post-date">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                <line x1="16" y1="2" x2="16" y2="6"></line>
                                <line x1="8" y1="2" x2="8" y2="6"></line>
                                <line x1="3" y1="10" x2="21" y2="10"></line>
                            </svg>
                            <?php echo get_the_date( 'd \d\e F \d\e Y' ); ?>
                        </span>

                        <span class="post-author">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                <circle cx="12" cy="7" r="4"></circle>
                            </svg>
                            Por <?php the_author(); ?>
                        </span>
                    </div>
                </header>

                <!-- Contenido del post -->
                <div class="post-content">
                    <?php the_content(); ?>
                </div>

                <!-- Tags -->
                <?php
                $tags = get_the_tags();
                if ( $tags ) :
                    ?>
                    <footer class="post-footer">
                        <div class="post-tags">
                            <span class="tags-label">Etiquetas:</span>
                            <?php
                            foreach ( $tags as $tag ) {
                                echo '<a href="' . esc_url( get_tag_link( $tag->term_id ) ) . '" class="tag">' . esc_html( $tag->name ) . '</a>';
                            }
                            ?>
                        </div>
                    </footer>
                <?php endif; ?>

                <!-- Navegación entre posts -->
                <nav class="post-navigation" aria-label="Navegación de posts">
                    <div class="nav-previous">
                        <?php
                        $prev_post = get_previous_post();
                        if ( $prev_post ) :
                            ?>
                            <a href="<?php echo esc_url( get_permalink( $prev_post->ID ) ); ?>" rel="prev">
                                <span class="nav-arrow">←</span>
                                <span class="nav-text">
                                    <span class="nav-label">Anterior</span>
                                    <span class="nav-title"><?php echo esc_html( $prev_post->post_title ); ?></span>
                                </span>
                            </a>
                        <?php endif; ?>
                    </div>

                    <div class="nav-home">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="btn-home">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                <polyline points="9 22 9 12 15 12 15 22"></polyline>
                            </svg>
                            Volver al inicio
                        </a>
                    </div>

                    <div class="nav-next">
                        <?php
                        $next_post = get_next_post();
                        if ( $next_post ) :
                            ?>
                            <a href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>" rel="next">
                                <span class="nav-text">
                                    <span class="nav-label">Siguiente</span>
                                    <span class="nav-title"><?php echo esc_html( $next_post->post_title ); ?></span>
                                </span>
                                <span class="nav-arrow">→</span>
                            </a>
                        <?php endif; ?>
                    </div>
                </nav>
            </div>
        </article>

        <!-- Sección de Últimas Noticias -->
        <section class="related-posts-section">
            <div class="related-posts-container">
                <h2 class="related-posts-title">Últimas Noticias</h2>
                <div class="section-divider"></div>

                <?php
                // Obtener las últimas 3 noticias, excluyendo el post actual
                $related_args = array(
                    'post_type'      => 'post',
                    'posts_per_page' => 3,
                    'post__not_in'   => array( get_the_ID() ),
                    'orderby'        => 'date',
                    'order'          => 'DESC',
                    'post_status'    => 'publish'
                );

                $related_query = new WP_Query( $related_args );

                if ( $related_query->have_posts() ) :
                    ?>
                    <div class="related-posts-grid">
                        <?php while ( $related_query->have_posts() ) : $related_query->the_post(); ?>
                            <article class="related-post-card">
                                <a href="<?php the_permalink(); ?>">
                                    <div class="related-post-image">
                                        <?php if ( has_post_thumbnail() ) : ?>
                                            <?php the_post_thumbnail( 'medium' ); ?>
                                        <?php else : ?>
                                            <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/cuadros/investigacion.jpg' ) ); ?>" alt="<?php the_title_attribute(); ?>">
                                        <?php endif; ?>
                                        <div class="related-post-overlay">
                                            <?php
                                            $categories = get_the_category();
                                            if ( ! empty( $categories ) ) :
                                                ?>
                                                <span class="related-post-category"><?php echo esc_html( strtoupper( $categories[0]->name ) ); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="related-post-content">
                                        <time class="related-post-date">
                                            📅 <?php echo get_the_date( 'd M Y' ); ?>
                                        </time>
                                        <h3 class="related-post-title"><?php the_title(); ?></h3>
                                        <p class="related-post-excerpt">
                                            <?php echo wp_trim_words( get_the_excerpt(), 15, '...' ); ?>
                                        </p>
                                        <span class="related-post-button">Leer más →</span>
                                    </div>
                                </a>
                            </article>
                        <?php endwhile; ?>
                    </div>
                <?php
                wp_reset_postdata();
                else :
                    ?>
                    <p class="no-related-posts">No hay más noticias disponibles en este momento.</p>
                <?php endif; ?>
            </div>
        </section>

    <?php endwhile; ?>
</main>

<?php get_footer(); ?>
