<?php
/**
 * Template principal del tema UNSM
 *
 * @package UNSM_Theme
 * @since 1.0.0
 */

get_header();
?>

    <main id="main-content">
        <!-- Carrusel Principal -->
        <section class="carousel" role="region" aria-label="Carrusel de imágenes destacadas" aria-roledescription="carousel">
            <div class="carousel-container" id="carouselContainer">
                <!-- Slide 1 -->
                <div class="carousel-slide" role="group" aria-roledescription="slide" aria-label="1 de 4">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/frotis unsm.jpg' ) ); ?>" alt="Vista panorámica del campus principal de la Universidad Nacional de San Martín" loading="eager" width="1920" height="600">
                    <div class="carousel-overlay">
                        <h1>Universidad Nacional de San Martín</h1>
                        <p>Excelencia Académica en la Amazonía Peruana</p>
                        <button class="carousel-button btn-inscribete" aria-label="Inscribirse en el proceso de admisión UNSM 2025">INSCRÍBETE AQUÍ</button>
                    </div>
                </div>
                
                <!-- Slide 2 -->
                <div class="carousel-slide" role="group" aria-roledescription="slide" aria-label="2 de 4">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/richard comedor.jpg' ) ); ?>" alt="Instalaciones modernas y servicios para estudiantes de la UNSM" loading="lazy" width="1920" height="600">
                    <div class="carousel-overlay">
                        <h2>Formación Integral</h2>
                        <p>Profesionales competitivos con valores</p>
                        <button class="carousel-button btn-inscribete" aria-label="Conocer más sobre la oferta académica">CONOCE MÁS</button>
                    </div>
                </div>
                
                <!-- Slide 3 -->
                <div class="carousel-slide" role="group" aria-roledescription="slide" aria-label="3 de 4">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/frotis unsm.jpg' ) ); ?>" alt="Proceso de admisión 2025 en la UNSM" loading="lazy" width="1920" height="600">
                    <div class="carousel-overlay">
                        <h2>Admisión 2025</h2>
                        <p>Inicia tu camino hacia la excelencia profesional</p>
                        <button class="carousel-button btn-inscribete" aria-label="Ver información completa de admisión">POSTULA AHORA</button>
                    </div>
                </div>
                
                <!-- Slide 4 -->
                <div class="carousel-slide" role="group" aria-roledescription="slide" aria-label="4 de 4">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/carreras.png' ) ); ?>" alt="11 facultades con carreras profesionales acreditadas en la UNSM" loading="lazy" width="1920" height="600">
                    <div class="carousel-overlay">
                        <h2>Carreras Profesionales</h2>
                        <p>11 facultades con programas acreditados</p>
                        <button class="carousel-button btn-inscribete" aria-label="Explorar todas las carreras disponibles">DESCUBRE MÁS</button>
                    </div>
                </div>
            </div>
            
            <!-- Controles del Carrusel -->
            <button class="carousel-prev" onclick="moveSlide(-1)" aria-label="Ir al slide anterior">
                <span aria-hidden="true">‹</span>
            </button>
            <button class="carousel-next" onclick="moveSlide(1)" aria-label="Ir al siguiente slide">
                <span aria-hidden="true">›</span>
            </button>
            
            <!-- Indicadores -->
            <div class="carousel-indicators" id="carouselControls" role="tablist" aria-label="Controles del carrusel"></div>
        </section>

        <!-- SECCIÓN DESTACADOS -->
        <section class="destacados-section" aria-labelledby="destacados-title">
            <div class="destacados-grid">
                <a href="#investigacion" class="destacado-card investigacion-card">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/cuadros/investigacion.jpg' ) ); ?>" alt="Investigación UNSM" loading="lazy">
                    <div class="destacado-overlay"></div>
                    <h3>INVESTIGACIÓN</h3>
                </a>
                <a href="#filiales" class="destacado-card filiales-card">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/cuadros/filial.jpg' ) ); ?>" alt="Filiales UNSM" loading="lazy">
                    <div class="destacado-overlay"></div>
                    <h3>FILIALES</h3>
                </a>
                <a href="#servicios-complementarios" class="destacado-card servicios-card">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/cuadros/servicios complementarios.jpg' ) ); ?>" alt="Servicios Complementarios UNSM" loading="lazy">
                    <div class="destacado-overlay"></div>
                    <h3>SERVICIOS COMPLEMENTARIOS</h3>
                </a>
                <a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Academicos/Seguimiento al Egresado e Insercion Laboral/indexSegui.php' ) ); ?>" class="destacado-card bolsa-card">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/cuadros/bolsa de trabajo.jpg' ) ); ?>" alt="Bolsa de Trabajo y Red de Egresados UNSM" loading="lazy">
                    <div class="destacado-overlay"></div>
                    <h3>BOLSA DE TRABAJO Y RED DE EGRESADOS</h3>
                </a>
            </div>
        </section>

        <!-- SECCIÓN OFERTA ACADÉMICA -->
        <section class="ofertas section-container" aria-labelledby="oferta-academica-title">
            <div class="content-wrapper">
                <h2 id="oferta-academica-title" class="section-title">Oferta Académica</h2>
                <div class="section-divider" aria-hidden="true"></div>
                
                <div class="cards-container-three">
                    <!-- Tarjeta 1: Programas de Pregrado -->
                    <article class="card">
                        <a href="#pregrado" aria-labelledby="pregrado-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"></path>
                                    <path d="M22 3h-6a4 4 0 0 0-4 4v14a3 3 0 0 1 3-3h7z"></path>
                                </svg>
                            </div>
                            <h3 id="pregrado-title" class="card-title">Programas de Pregrado</h3>
                            <p class="card-text">11 facultades con carreras innovadoras que forman profesionales de alto nivel, listos para liderar y transformar la región</p>
                        </a>
                    </article>

                    <!-- Tarjeta 2: Escuela de Posgrado -->
                    <article class="card">
                        <a href="#posgrado" aria-labelledby="posgrado-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                                    <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                                </svg>
                            </div>
                            <h3 id="posgrado-title" class="card-title">Escuela de Posgrado</h3>
                            <p class="card-text">Maestrías y doctorados para quienes desean especializarse y convertirse en líderes de investigación y gestión</p>
                        </a>
                    </article>

                    <!-- Tarjeta 3: Formación Continua -->
                    <article class="card">
                        <a href="#formacion-continua" aria-labelledby="formacion-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="9" cy="7" r="4"></circle>
                                    <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                                    <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                </svg>
                            </div>
                            <h3 id="formacion-title" class="card-title">Formación Continua</h3>
                            <p class="card-text">Programas de actualización profesional, certificaciones y capacitación especializada para el desarrollo continuo</p>
                        </a>
                    </article>
                </div>
            </div>
        </section>

        <!-- SECCIÓN ACADÉMICO -->
        <section class="academico section-container" aria-labelledby="academico-title">
            <div class="content-wrapper">
                <h2 id="academico-title" class="section-title">Académico</h2>
                <div class="section-divider" aria-hidden="true"></div>
                
                <div class="academic-carousel-wrapper">
                    <div class="cards-container-academic-six" id="academicCarouselContainer">
                        <!-- Tarjeta 1: CPU - UNSM -->
                        <article class="card academic-carousel-slide">
                            <a href="#cpu" aria-labelledby="cpu-title">
                                <div class="card-image">
                                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/academico/centro preuniversitario.png' ) ); ?>" alt="Centro Preuniversitario UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="9" cy="7" r="4"></circle>
                                        <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                                        <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                    </svg>
                                </div>
                                <h3 id="cpu-title" class="card-title">CPU - UNSM</h3>
                                <p class="card-text">El Centro Preuniversitario brinda preparación académica integral para el ingreso a la universidad</p>
                            </a>
                        </article>

                        <!-- Tarjeta 2: Centro de Idiomas -->
                        <article class="card academic-carousel-slide">
                            <a href="#centro-idiomas" aria-labelledby="idiomas-title">
                                <div class="card-image">
                                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/academico/centro de idiomas.png' ) ); ?>" alt="Centro de Idiomas UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M12 2a10 10 0 1 0 0 20 10 10 0 0 0 0-20z"></path>
                                        <path d="M2 12h20M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path>
                                    </svg>
                                </div>
                                <h3 id="idiomas-title" class="card-title">Centro de Idiomas</h3>
                                <p class="card-text">La UNSM te ofrece programas certificados de inglés, portugués, francés, italiano, quechua y más</p>
                            </a>
                        </article>

                        <!-- Tarjeta 3: Campus Virtual -->
                        <article class="card academic-carousel-slide">
                            <a href="#campus-virtual" aria-labelledby="campus-title">
                                <div class="card-image">
                                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/academico/CAMPUS VIRTUAL.png' ) ); ?>" alt="Campus Virtual UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                        <polyline points="9 22 9 12 15 12 15 22"></polyline>
                                    </svg>
                                </div>
                                <h3 id="campus-title" class="card-title">Campus Virtual</h3>
                                <p class="card-text">Plataforma Docente de la Universidad Nacional de San Martín para recursos y estudios online</p>
                            </a>
                        </article>

                        <!-- Tarjeta 4: Investigación y Desarrollo -->
                        <article class="card academic-carousel-slide">
                            <a href="#investigacion" aria-labelledby="investigacion-title">
                                <div class="card-image">
                                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/academico/escuela de posgrado.jpg' ) ); ?>" alt="Investigación y Desarrollo UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <circle cx="11" cy="11" r="8"></circle>
                                        <path d="m21 21-4.35-4.35"></path>
                                    </svg>
                                </div>
                                <h3 id="investigacion-title" class="card-title">Investigación y Desarrollo</h3>
                                <p class="card-text">La Oficina de Investigación Universitaria se encarga de proyectos de investigación regional</p>
                            </a>
                        </article>

                        <!-- Tarjeta 5: Escuela de Posgrado -->
                        <article class="card academic-carousel-slide">
                            <a href="#escuela-posgrado" aria-labelledby="escuela-posgrado-title">
                                <div class="card-image">
                                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/academico/escuela de posgrado.jpg' ) ); ?>" alt="Escuela de Posgrado UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                                        <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                                    </svg>
                                </div>
                                <h3 id="escuela-posgrado-title" class="card-title">Escuela de Posgrado</h3>
                                <p class="card-text">Nuestra Escuela de Posgrado ofrece programas de especialización y formación en investigación</p>
                            </a>
                        </article>

                        <!-- Tarjeta 6: CTI - UNSM -->
                        <article class="card academic-carousel-slide">
                            <a href="#cti-unsm" aria-labelledby="cti-title">
                                <div class="card-image">
                                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/academico/CTI.png' ) ); ?>" alt="Centro de Tecnologías de Información UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                                        <line x1="8" y1="21" x2="16" y2="21"></line>
                                        <line x1="12" y1="17" x2="12" y2="21"></line>
                                    </svg>
                                </div>
                                <h3 id="cti-title" class="card-title">CTI - UNSM</h3>
                                <p class="card-text">El Centro de Tecnologías de Información se encarga de brindar soporte tecnológico</p>
                            </a>
                        </article>
                    </div>

                    <!-- Controles del carrusel (solo móvil) -->
                    <button class="academic-carousel-prev" onclick="moveAcademicSlide(-1)" aria-label="Tarjetas académicas anteriores">
                        <span aria-hidden="true">‹</span>
                    </button>
                    <button class="academic-carousel-next" onclick="moveAcademicSlide(1)" aria-label="Siguientes tarjetas académicas">
                        <span aria-hidden="true">›</span>
                    </button>
                    
                    <!-- Indicadores (solo móvil) -->
                    <div class="academic-carousel-indicators" id="academicCarouselDots" role="tablist" aria-label="Indicadores de tarjetas académicas"></div>
                </div>
            </div>
        </section>

        <!-- SECCIÓN FACULTADES CON CARRUSEL INFINITO -->
        <section class="facultades section-container" aria-labelledby="facultades-title">
            <div class="content-wrapper">
                <h2 id="facultades-title" class="section-title">Nuestras Facultades</h2>
                <div class="section-divider" aria-hidden="true"></div>
                
                <div class="facultades-carousel-wrapper">
                    <div class="facultades-carousel-container" id="facultadesCarouselContainer" role="region" aria-label="Carrusel de facultades">
                        <!-- Los slides se generarán dinámicamente por JavaScript para incluir clones -->
                    </div>
                    
                    <button class="carousel-prev facultades-prev" onclick="moveFacultadesSlide(-1)" aria-label="Facultades anteriores">
                        <span aria-hidden="true">‹</span>
                    </button>
                    <button class="carousel-next facultades-next" onclick="moveFacultadesSlide(1)" aria-label="Siguientes facultades">
                        <span aria-hidden="true">›</span>
                    </button>
                    
                    <!-- Indicadores -->
                    <div class="carousel-indicators" id="facultadesDots" role="tablist" aria-label="Indicadores de facultades"></div>
                </div>
            </div>
        </section>

        <!-- SECCIÓN NOTICIAS -->
        <section class="noticias section-container" aria-labelledby="noticias-title">
            <div class="content-wrapper">
                <h2 id="noticias-title" class="section-title">Últimas Noticias</h2>
                <div class="section-divider" aria-hidden="true"></div>
                
                <div class="cards-container">
                    <!-- Noticia 1 -->
                    <article class="card">
                        <a href="#noticia1" aria-labelledby="noticia1-title">
                            <div class="card-image">
                                <div class="card-overlay-green">
                                    <span class="news-category">EVENTO</span>
                                </div>
                            </div>
                            <div class="card-content">
                                <time class="news-meta" datetime="2025-11-15">
                                    <span>📅 15 Nov 2025</span>
                                </time>
                                <h3 id="noticia1-title" class="card-title">Congreso 2025</h3>
                                <p class="card-text">Congreso Internacional de Investigación Científica reunirá a destacados investigadores</p>
                                <span class="card-button">Leer más</span>
                            </div>
                        </a>
                    </article>

                    <!-- Noticia 2 -->
                    <article class="card">
                        <a href="#noticia2" aria-labelledby="noticia2-title">
                            <div class="card-image">
                                <div class="card-overlay-green">
                                    <span class="news-category">ADMISIÓN</span>
                                </div>
                            </div>
                            <div class="card-content">
                                <time class="news-meta" datetime="2025-11-10">
                                    <span>📅 10 Nov 2025</span>
                                </time>
                                <h3 id="noticia2-title" class="card-title">Admisión</h3>
                                <p class="card-text">Proceso de Admisión 2025: Conoce las fechas importantes y requisitos</p>
                                <span class="card-button">Leer más</span>
                            </div>
                        </a>
                    </article>

                    <!-- Noticia 3 -->
                    <article class="card">
                        <a href="#noticia3" aria-labelledby="noticia3-title">
                            <div class="card-image">
                                <div class="card-overlay-green">
                                    <span class="news-category">INVESTIGACIÓN</span>
                                </div>
                            </div>
                            <div class="card-content">
                                <time class="news-meta" datetime="2025-11-05">
                                    <span>📅 5 Nov 2025</span>
                                </time>
                                <h3 id="noticia3-title" class="card-title">Investigación</h3>
                                <p class="card-text">Proyecto de Investigación de la UNSM gana reconocimiento internacional</p>
                                <span class="card-button">Leer más</span>
                            </div>
                        </a>
                    </article>
                </div>
            </div>
        </section>

        <!-- SECCIÓN ADMINISTRATIVOS -->
        <section class="administrativos section-container" aria-labelledby="administrativos-title">
            <div class="content-wrapper">
                <h2 id="administrativos-title" class="section-title">Administrativos</h2>
                <div class="section-divider" aria-hidden="true"></div>
                
                <div class="cards-container-three">
                    <!-- Tarjeta 1: Sistema de Gestión Documentaria -->
                    <article class="card">
                        <a href="#gestion-documentaria" aria-labelledby="gestion-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                    <polyline points="14 2 14 8 20 8"></polyline>
                                    <line x1="16" y1="13" x2="8" y2="13"></line>
                                    <line x1="16" y1="17" x2="8" y2="17"></line>
                                    <polyline points="10 9 9 9 8 9"></polyline>
                                </svg>
                            </div>
                            <h3 id="gestion-title" class="card-title">Sistema de Gestión Documentaria</h3>
                            <p class="card-text">Trámite de expedientes y registro electrónico de documentos oficiales</p>
                        </a>
                    </article>

                    <!-- Tarjeta 2: Servicios -->
                    <article class="card">
                        <a href="#servicios" aria-labelledby="servicios-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                            </div>
                            <h3 id="servicios-title" class="card-title">Servicios</h3>
                            <p class="card-text">Atención personalizada in biblioteca, registro de títulos, y soporte técnico para estudiantes</p>
                        </a>
                    </article>

                    <!-- Tarjeta 3: Mesa de Ayuda -->
                    <article class="card">
                        <a href="#mesa-ayuda" aria-labelledby="ayuda-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <circle cx="12" cy="12" r="10"></circle>
                                    <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path>
                                    <line x1="12" y1="17" x2="12.01" y2="17"></line>
                                </svg>
                            </div>
                            <h3 id="ayuda-title" class="card-title">Mesa de Ayuda</h3>
                            <p class="card-text">Atención rápida para consultas académicas, trámites administrativos, y soporte para plataforma virtual</p>
                        </a>
                    </article>
                </div>
            </div>
        </section>

        <!-- SECCIÓN ENLACES DE INTERÉS -->
        <section class="enlaces-interes" aria-labelledby="enlaces-title">
            <div class="content-wrapper">
                <h2 id="enlaces-title" class="section-title-enlaces">Enlaces de Interés</h2>
                <div class="section-divider-enlaces" aria-hidden="true"></div>
                
                <nav class="enlaces-grid-buttons" aria-label="Enlaces de interés y servicios">
                    <!-- COLUMNA 1 -->
                    <a href="#correo-institucional" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                            <polyline points="22,6 12,13 2,6"></polyline>
                        </svg>
                        <span>Correo Institucional</span>
                    </a>
                    
                    <a href="#biblioteca-central" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M4 19.5A2.5 2.5 0 0 1 6.5 17H20"></path>
                            <path d="M6.5 2H20v20H6.5A2.5 2.5 0 0 1 4 19.5v-15A2.5 2.5 0 0 1 6.5 2z"></path>
                        </svg>
                        <span>Biblioteca Central</span>
                    </a>
                    
                    <a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Academicos/Seguimiento al Egresado e Insercion Laboral/indexSegui.php' ) ); ?>" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                            <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                        </svg>
                        <span>Sistema de Egresados</span>
                    </a>
                    
                    <a href="#mesa-partes-digital" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                            <polyline points="14 2 14 8 20 8"></polyline>
                        </svg>
                        <span>Mesa de Partes Digital</span>
                    </a>
                    
                    <a href="#sigau-docente" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                            <circle cx="9" cy="7" r="4"></circle>
                        </svg>
                        <span>Sigau Docente</span>
                    </a>

                    <!-- COLUMNA 2 -->
                    <a href="#convocatoria-personal" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                            <circle cx="8.5" cy="7" r="4"></circle>
                            <line x1="20" y1="8" x2="20" y2="14"></line>
                            <line x1="23" y1="11" x2="17" y2="11"></line>
                        </svg>
                        <span>Convocatoria de Personal</span>
                    </a>
                    
                    <a href="#gestion-documental" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                            <polyline points="14 2 14 8 20 8"></polyline>
                        </svg>
                        <span>Gestión Documental (SGD)</span>
                    </a>
                    
                    <a href="#grados-titulos" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                            <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                        </svg>
                        <span>Grados y Títulos</span>
                    </a>
                    
                    <a href="#servicios-generales" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <circle cx="12" cy="12" r="3"></circle>
                            <path d="M12 1v6m0 6v6"></path>
                        </svg>
                        <span>Servicios</span>
                    </a>
                    
                    <a href="#sigau-matricula" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <circle cx="12" cy="12" r="10"></circle>
                            <polyline points="12 6 12 12 16 14"></polyline>
                        </svg>
                        <span>Sigau Matrícula</span>
                    </a>

                    <!-- COLUMNA 3 -->
                    <a href="#bienestar-universitario" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28"></path>
                        </svg>
                        <span>Bienestar Universitario</span>
                    </a>
                    
                    <a href="#cti" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                            <line x1="8" y1="21" x2="16" y2="21"></line>
                        </svg>
                        <span>CTI</span>
                    </a>
                    
                    <a href="#acreditacion" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                            <circle cx="12" cy="12" r="10"></circle>
                        </svg>
                        <span>Oficina de Acreditación</span>
                    </a>
                    
                    <a href="#sigau-intranet" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                            <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                        </svg>
                        <span>Sigau Intranet</span>
                    </a>
                    
                    <a href="#sigau-bienestar" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06"></path>
                        </svg>
                        <span>Sigau Bienestar</span>
                    </a>

                    <!-- COLUMNA 4 -->
                    <a href="#pagos-virtuales" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <line x1="12" y1="1" x2="12" y2="23"></line>
                            <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5"></path>
                        </svg>
                        <span>Pagos Virtuales</span>
                    </a>
                    
                    <a href="#repositorio-digital" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"></path>
                            <path d="M22 3h-6a4 4 0 0 0-4 4v14"></path>
                        </svg>
                        <span>Repositorio Digital</span>
                    </a>
                    
                    <a href="#museo-regional" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path>
                            <circle cx="12" cy="10" r="3"></circle>
                        </svg>
                        <span>Museo Regional</span>
                    </a>
                    
                    <a href="#sigau-tutoria" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M12 2L2 7l10 5 10-5-10-5z"></path>
                            <path d="M2 17l10 5 10-5"></path>
                        </svg>
                        <span>Sigau Tutoría</span>
                    </a>
                    
                    <a href="#aula-virtual" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"></path>
                            <line x1="10" y1="12" x2="14" y2="12"></line>
                        </svg>
                        <span>Aula Virtual</span>
                    </a>
                </nav>
            </div>
        </section>
    </main>

<?php get_footer(); ?>
