<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Universidad Nacional de San Martín - UNSM en Tarapoto, Perú. 11 facultades con programas acreditados, admisión 2025, posgrado e investigación de excelencia en la Amazonía.">
    <meta name="keywords" content="UNSM, Universidad San Martín, educación superior Tarapoto, universidad Perú, admisión universidad, facultades UNSM, posgrado Tarapoto">
    <meta name="author" content="Universidad Nacional de San Martín">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#359444">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo esc_url( home_url( '/' ) ); ?>">
    <meta property="og:title" content="<?php bloginfo( 'name' ); ?> | Excelencia Académica en la Amazonía">
    <meta property="og:description" content="Institución de educación superior con 11 facultades, programas acreditados y formación integral en Tarapoto, San Martín, Perú">
    <meta property="og:image" content="<?php echo esc_url( unsm_asset_url( 'imagenes/logo UNSM.png' ) ); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo esc_url( home_url( '/' ) ); ?>">
    <meta property="twitter:title" content="<?php bloginfo( 'name' ); ?>">
    <meta property="twitter:description" content="Formación profesional de excelencia en la Amazonía peruana">
    <meta property="twitter:image" content="<?php echo esc_url( unsm_asset_url( 'imagenes/logo UNSM.png' ) ); ?>">

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo esc_url( unsm_asset_url( 'imagenes/escudo unsm.png' ) ); ?>" sizes="48x48">
    <link rel="apple-touch-icon" href="<?php echo esc_url( unsm_asset_url( 'imagenes/escudo unsm.png' ) ); ?>">

    <!-- Preconnect to external domains -->
    <link rel="preconnect" href="https://www.facebook.com">
    <link rel="preconnect" href="https://www.instagram.com">

    <!-- Schema.org markup para Google -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "EducationalOrganization",
      "name": "Universidad Nacional de San Martín",
      "alternateName": "UNSM",
      "url": "<?php echo esc_url( home_url( '/' ) ); ?>",
      "logo": "<?php echo esc_url( unsm_asset_url( 'imagenes/logo UNSM.png' ) ); ?>",
      "description": "Universidad pública en Tarapoto con 11 facultades y programas acreditados de pregrado y posgrado",
      "address": {
        "@type": "PostalAddress",
        "streetAddress": "Jr. Maynas N° 177 - Morales",
        "addressLocality": "Tarapoto",
        "addressRegion": "San Martín",
        "postalCode": "22201",
        "addressCountry": "PE"
      },
      "telephone": "+51-42-480159",
      "email": "informes@unsm.edu.pe",
      "sameAs": [
        "https://www.facebook.com/unsmperu",
        "https://www.instagram.com/unsmperu",
        "https://youtube.com/@unsmperu",
        "https://x.com/unsmperu",
        "https://www.tiktok.com/@campus.unsm"
      ],
      "foundingDate": "1979",
      "areaServed": {
        "@type": "Place",
        "name": "San Martín, Perú"
      }
    }
    </script>

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

    <!-- Skip to main content for accessibility -->
    <a href="#main-content" class="skip-to-content">Saltar al contenido principal</a>

    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en Facebook" aria-label="Página oficial de Facebook de la UNSM">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/redes/logo facebook.png' ) ); ?>" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Síguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/redes/logo instagram.png' ) ); ?>" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/redes/logo yt.png' ) ); ?>" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/redes/logo x.png' ) ); ?>" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Síguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/redes/logo tiktok.png' ) ); ?>" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/logo telefono.png' ) ); ?>" alt="Teléfono" class="contact-icon" width="18" height="18">
                    <span><?php echo esc_html( get_theme_mod( 'unsm_phone', '(+51) (042) 48 0159' ) ); ?></span>
                </span>
                <span>
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/logo correo.png' ) ); ?>" alt="Correo" class="contact-icon" width="18" height="18">
                    <span><?php echo esc_html( get_theme_mod( 'unsm_email', 'informes@unsm.edu.pe' ) ); ?></span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" aria-label="Ir a la página principal de UNSM">
                    <?php
                    if ( has_custom_logo() ) {
                        the_custom_logo();
                    } else {
                        ?>
                        <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/logo UNSM.png' ) ); ?>" alt="Logo de la Universidad Nacional de San Martín" width="auto" height="70">
                        <?php
                    }
                    ?>
                </a>
            </div>

            <!-- Botón Hamburguesa para móvil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menú de navegación" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">

                <!-- Logo en menú móvil -->
                <div class="mobile-nav-logo">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/logo UNSM.png' ) ); ?>" alt="Logo UNSM" width="auto" height="65">
                </div>

                <?php
                // Menú de navegación de WordPress
                if ( has_nav_menu( 'primary' ) ) {
                    unsm_navigation_menu();
                } else {
                    // Menú por defecto hardcodeado si no hay menú de WordPress asignado
                    ?>
                    <ul class="nav-menu">
                        <li class="dropdown">
                            <a href="<?php echo esc_url( home_url( '/nosotros' ) ); ?>" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                            <ul class="dropdown-menu" aria-label="Menú Nosotros">
                                <li><a href="<?php echo esc_url( unsm_asset_url( 'nosotros/autoridades/indexAuto.php' ) ); ?>">Autoridades</a></li>
                                <li><a href="<?php echo esc_url( unsm_asset_url( 'nosotros/historia/historia.php' ) ); ?>">Historia de la Universidad</a></li>
                                <li><a href="<?php echo esc_url( unsm_asset_url( 'nosotros/mision/indexMision.php' ) ); ?>">Nuestra Misión y Visión</a></li>
                                <li><a href="<?php echo esc_url( unsm_asset_url( 'nosotros/objetivos/objeIndex.php' ) ); ?>">Objetivos</a></li>
                                <li><a href="<?php echo esc_url( unsm_asset_url( 'nosotros/onigrama/indexOni.php' ) ); ?>">Organigrama</a></li>
                                <li><a href="<?php echo esc_url( unsm_asset_url( 'nosotros/himno/indexHimno.php' ) ); ?>">Himno</a></li>
                                <li><a href="<?php echo esc_url( unsm_asset_url( 'nosotros/directorioInstucional/indexDirec.php' ) ); ?>">Directorio Institucional</a></li>
                                <li><a href="<?php echo esc_url( unsm_asset_url( 'nosotros/calendarioAcade/indexCale.php' ) ); ?>">Calendario Académico</a></li>
                            </ul>
                        </li>
                        <li class="dropdown dropdown-wide">
                            <a href="<?php echo esc_url( home_url( '/oficinas' ) ); ?>" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                            <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                                <div class="dropdown-column">
                                    <li class="dropdown-header">Oficinas Administrativas</li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/rectorado/indexRecto.php' ) ); ?>">Rectorado</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/vicerrectorado academico/indexVicerec.php' ) ); ?>">Vicerrectorado Académico</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/vicerrectorado de investigacion/indexViceRecAca.php' ) ); ?>">Vicerrectorado de Investigación</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/secretaria general/indexSecreGene.php' ) ); ?>">Secretaría General</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/planeamiento y presupuesto/indexPlanea.php' ) ); ?>">Planeamiento y Presupuesto</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/seguridad y salud ocupacional/indexSeguri.php' ) ); ?>">Seguridad y Salud Ocupacional</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/comunicacion y imagen institucional/indexImagen.php' ) ); ?>">Comunicación e Imagen Institucional</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php' ) ); ?>">Cooperación y Relaciones Internacionales</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Organo de Control Institucional/indexOrgaConIns.php' ) ); ?>">Órgano de Control Institucional</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Ejecutora de Inversiones/indexEjec.php' ) ); ?>">Ejecutora de Inversiones</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Asesoria Juridica/indexAseJuri.php' ) ); ?>">Asesoría Jurídica</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Grados y Titulos/indexGrados.php' ) ); ?>">Grados y Títulos</a></li>
                                </div>
                                <div class="dropdown-column">
                                    <li class="dropdown-header">Oficinas Académicas</li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Academicos/OFICINA DE ADMISION/indexOfiAdmin.php' ) ); ?>">Oficina de Admisión</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Academicos/ASUNTOS ACADEMICOS/indexAsunAca.php' ) ); ?>">Asuntos Académicos</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Academicos/Seguimiento al Egresado e Insercion Laboral/indexSegui.php' ) ); ?>">Seguimiento al Egresado e Inserción Laboral</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Academicos/TECNOLOGIAS DE LA INFORMACION/indexOTI.php' ) ); ?>">Tecnologías de la Información</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Academicos/INCUBADORA DE EMPRESAS/indexIncu.php' ) ); ?>">Incubadora de Empresas</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Academicos/FONDO EDITORIAL/indexFondo.php' ) ); ?>">Fondo Editorial</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Academicos/COMITE ELECTORAL UNIVERSITARIO/indexComite.php' ) ); ?>">Comité Electoral Universitario</a></li>
                                    <li><a href="<?php echo esc_url( unsm_asset_url( 'oficinas/Academicos/INNOVACION Y TRANSFERENCIA TECNOLOGICA/indexInno.php' ) ); ?>">Innovación y Transferencia Tecnológica</a></li>
                                    <li><a href="<?php echo esc_url( home_url( '/produccion' ) ); ?>">Producción de Bienes y Servicios</a></li>
                                    <li><a href="<?php echo esc_url( home_url( '/responsabilidad' ) ); ?>">Responsabilidad Social Universitaria</a></li>
                                    <li><a href="<?php echo esc_url( home_url( '/servicios-generales' ) ); ?>">Servicios Generales</a></li>
                                    <li><a href="<?php echo esc_url( home_url( '/bienestar' ) ); ?>">Bienestar Universitario</a></li>
                                    <li><a href="<?php echo esc_url( home_url( '/defensoria' ) ); ?>">Defensoría Universitaria</a></li>
                                    <li><a href="<?php echo esc_url( home_url( '/calidad' ) ); ?>">Gestión de la Calidad</a></li>
                                </div>
                            </ul>
                        </li>
                        <li><a href="<?php echo esc_url( unsm_asset_url( 'admision/indexAdmin.php' ) ); ?>">ADMISIÓN</a></li>
                        <li><a href="<?php echo esc_url( home_url( '/cpu' ) ); ?>">CPU</a></li>
                        <li class="dropdown dropdown-facultades">
                            <a href="<?php echo esc_url( home_url( '/facultades' ) ); ?>" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                            <ul class="dropdown-menu" aria-label="Menú Facultades">
                                <li class="has-submenu">
                                    <a href="<?php echo esc_url( unsm_asset_url( 'facultades/ciencias agrarias/indexAgra.php' ) ); ?>" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                    <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                        <li><a href="<?php echo esc_url( unsm_asset_url( 'facultades/ciencias agrarias/agronomia/indexAgro.php' ) ); ?>">Agronomía</a></li>
                                    </ul>
                                </li>
                                <li class="has-submenu">
                                    <a href="#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                    <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                        <li><a href="#obstetricia">Obstetricia</a></li>
                                    </ul>
                                </li>
                                <li class="has-submenu">
                                    <a href="#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                    <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                        <li><a href="#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                    </ul>
                                </li>
                                <li class="has-submenu">
                                    <a href="#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingeniería Agroindustrial</a>
                                    <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Agroindustrial">
                                        <li><a href="#ing-agroindustrial">Ingeniería Agroindustrial</a></li>
                                    </ul>
                                </li>
                                <li class="has-submenu">
                                    <a href="#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingeniería Civil y Arquitectura</a>
                                    <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Civil y Arquitectura">
                                        <li><a href="#arquitectura">Arquitectura</a></li>
                                        <li><a href="#ingenieria-civil-carrera">Ingeniería Civil</a></li>
                                    </ul>
                                </li>
                                <li class="has-submenu">
                                    <a href="#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingeniería de Sistemas e Informática</a>
                                    <ul class="submenu-carreras" aria-label="Carreras de Ingeniería de Sistemas">
                                        <li><a href="#ing-sistemas">Ingeniería de Sistemas e Informática</a></li>
                                    </ul>
                                </li>
                                <li class="has-submenu">
                                    <a href="#ecologia" aria-haspopup="true" aria-expanded="false">Ecología</a>
                                    <ul class="submenu-carreras" aria-label="Carreras de Ecología">
                                        <li><a href="#ing-ambiental">Ingeniería Ambiental</a></li>
                                        <li><a href="#ing-sanitaria">Ingeniería Sanitaria</a></li>
                                    </ul>
                                </li>
                                <li class="has-submenu">
                                    <a href="#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Políticas</a>
                                    <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                        <li><a href="#derecho-carrera">Derecho</a></li>
                                    </ul>
                                </li>
                                <li class="has-submenu">
                                    <a href="#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                    <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                        <li><a href="#medicina-humana-carrera">Medicina Humana</a></li>
                                        <li><a href="#enfermeria">Enfermería</a></li>
                                    </ul>
                                </li>
                                <li class="has-submenu">
                                    <a href="#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Económicas</a>
                                    <ul class="submenu-carreras" aria-label="Carreras de Ciencias Económicas">
                                        <li><a href="#administracion">Administración</a></li>
                                        <li><a href="#contabilidad">Contabilidad</a></li>
                                        <li><a href="#economia">Economía</a></li>
                                        <li><a href="#turismo">Turismo</a></li>
                                    </ul>
                                </li>
                                <li class="has-submenu">
                                    <a href="<?php echo esc_url( unsm_asset_url( 'facultades/educacion y humanidades/indexEdu.php' ) ); ?>" aria-haspopup="true" aria-expanded="false">Educación y Humanidades</a>
                                    <ul class="submenu-carreras" aria-label="Carreras de Educación">
                                        <li><a href="<?php echo esc_url( unsm_asset_url( 'facultades/educacion y humanidades/indexEdu.php#educacion-inicial' ) ); ?>">Educación Inicial</a></li>
                                        <li><a href="<?php echo esc_url( unsm_asset_url( 'facultades/educacion y humanidades/indexEdu.php#educacion-primaria' ) ); ?>">Educación Primaria</a></li>
                                        <li><a href="<?php echo esc_url( unsm_asset_url( 'facultades/educacion y humanidades/indexEdu.php#educacion-secundaria' ) ); ?>">Educación Secundaria</a></li>
                                        <li><a href="<?php echo esc_url( unsm_asset_url( 'facultades/educacion y humanidades/indexEdu.php#idiomas' ) ); ?>">Idiomas</a></li>
                                        <li>
                                            <a href="<?php echo esc_url( unsm_asset_url( 'facultades/educacion y humanidades/psicologia/indexPsico.php' ) ); ?>">
                                                Psicología
                                                <span class="badge-nuevo">Nuevo</span>
                                            </a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li><a href="<?php echo esc_url( home_url( '/posgrado' ) ); ?>">POSGRADO</a></li>
                        <li class="dropdown">
                            <a href="<?php echo esc_url( home_url( '/transparencia' ) ); ?>" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                            <ul class="dropdown-menu" aria-label="Menú Transparencia">
                                <li><a href="<?php echo esc_url( home_url( '/licenciamiento' ) ); ?>">Licenciamiento</a></li>
                                <li><a href="<?php echo esc_url( home_url( '/institucional' ) ); ?>">Institucional Ley 30220</a></li>
                                <li><a href="<?php echo esc_url( home_url( '/estandar' ) ); ?>">Estándar Ley 27806</a></li>
                            </ul>
                        </li>
                    </ul>
                    <?php
                }
                ?>

                <!-- Logos gob.pe dentro del menú móvil -->
                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/logo portal de trans.png' ) ); ?>" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Perú">
                        <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/logo gobPe.png' ) ); ?>" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/logo portal de trans.png' ) ); ?>" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Perú">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/logo gobPe.png' ) ); ?>" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>
