    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/escudo unsm.png' ) ); ?>" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p><?php echo esc_html( get_theme_mod( 'unsm_address', 'Jr. Maynas N° 177 - Morales' ) ); ?></p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central Telefónica: <span><?php echo esc_html( get_theme_mod( 'unsm_phone', '(+51) (042) 48 0159' ) ); ?></span></p>
                    <p>Email: <span><?php echo esc_html( get_theme_mod( 'unsm_email', 'informes@unsm.edu.pe' ) ); ?></span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="<?php echo esc_url( home_url( '/admision' ) ); ?>">Admisión</a></li>
                    <li><a href="<?php echo esc_url( home_url( '/facultades' ) ); ?>">Facultades</a></li>
                    <li><a href="<?php echo esc_url( home_url( '/posgrado' ) ); ?>">Posgrado</a></li>
                    <li><a href="<?php echo esc_url( home_url( '/investigacion' ) ); ?>">Investigación</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="<?php echo esc_url( home_url( '/biblioteca' ) ); ?>">Biblioteca Virtual</a></li>
                    <li><a href="<?php echo esc_url( home_url( '/campus-virtual' ) ); ?>">Campus Virtual</a></li>
                    <li><a href="<?php echo esc_url( home_url( '/repositorio' ) ); ?>">Repositorio Institucional</a></li>
                    <li><a href="<?php echo esc_url( home_url( '/transparencia' ) ); ?>">Portal de Transparencia</a></li>
                    <li><a href="<?php echo esc_url( home_url( '/libro-reclamaciones' ) ); ?>">Libro de Reclamaciones</a></li>
                    <li><a href="<?php echo esc_url( unsm_asset_url( 'contacto/indexContac.php' ) ); ?>">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Martín - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; <?php echo date( 'Y' ); ?> Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/redes/logo facebook.png' ) ); ?>" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/redes/logo instagram.png' ) ); ?>" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/redes/logo yt.png' ) ); ?>" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/redes/logo x.png' ) ); ?>" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="<?php echo esc_url( unsm_asset_url( 'imagenes/redes/logo tiktok.png' ) ); ?>" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <?php wp_footer(); ?>
</body>
</html>
