# UNSM Theme - Tema de WordPress

Tema oficial de la Universidad Nacional de San Martín convertido a WordPress.

## Descripción

Este es el tema completo de WordPress para el sitio web institucional de la UNSM. Incluye todas las funcionalidades y el diseño del sitio original, ahora totalmente integrado con WordPress.

## Características

- ✅ **Responsive Design**: Completamente adaptable a móviles, tablets y escritorio
- ✅ **Menús de Navegación**: Soporte completo para menús de WordPress
- ✅ **Widgets**: Áreas de widgets en sidebar y footer
- ✅ **Customizer**: Personalización de colores, teléfono y email desde el Customizer
- ✅ **SEO Optimizado**: Meta tags, Schema.org y Open Graph incluidos
- ✅ **Accesibilidad**: Cumple con estándares de accesibilidad web
- ✅ **Carruseles**: Carrusel principal y carruseles de contenido
- ✅ **Assets Organizados**: CSS, JavaScript e imágenes organizados

## Instalación

### Método 1: Activar desde el panel de WordPress

1. Accede al panel de administración de WordPress: `http://localhost/unsm/wordpress/wp-admin`
2. Ve a **Apariencia > Temas**
3. Localiza el tema "UNSM Theme"
4. Haz clic en **Activar**

### Método 2: Activar mediante código

Si el tema no aparece, verifica que esté en la ruta correcta:
```
C:\xampp\htdocs\unsm\wordpress\wp-content\themes\unsm-theme\
```

## Estructura del Tema

```
unsm-theme/
├── style.css           # Estilos principales del tema (con header de WordPress)
├── index.php           # Plantilla principal
├── header.php          # Cabecera del sitio
├── footer.php          # Pie de página
├── functions.php       # Funciones y configuración del tema
├── screenshot.png      # Captura de pantalla del tema
├── README.md           # Este archivo
├── imagenes/           # Imágenes del sitio
├── js/                 # JavaScript
│   └── script.js       # Script principal
└── assets/             # Directorio para futuros assets
    ├── css/
    ├── js/
    └── images/
```

## Configuración Inicial

### 1. Crear Menús

1. Ve a **Apariencia > Menús**
2. Crea un nuevo menú llamado "Menú Principal"
3. Agrega las páginas/enlaces que necesites
4. Asigna el menú a la ubicación "Menú Principal"

### 2. Personalizar Información de Contacto

1. Ve a **Apariencia > Personalizar**
2. Busca la sección "Información de Contacto"
3. Actualiza:
   - Teléfono
   - Email
   - Dirección

### 3. Configurar el Logo

1. Ve a **Apariencia > Personalizar > Identidad del sitio**
2. Haz clic en "Seleccionar logo"
3. Sube o selecciona el logo de la UNSM

## Compatibilidad con el Sitio Original

El tema está diseñado para mantener la compatibilidad con los archivos PHP originales del sitio. Las rutas de imágenes y assets se gestionan mediante la función `unsm_asset_url()` que busca primero en el tema y luego hace fallback a las rutas originales.

### Rutas de Assets

- **Imágenes**: `imagenes/` (copiadas al tema)
- **JavaScript**: `js/script.js` (copiado al tema)
- **Archivos PHP antiguos**: Se mantienen las rutas originales mediante fallback

## Funciones Principales

### `unsm_asset_url( $path )`
Obtiene la URL correcta de un asset, con fallback automático al sitio original.

**Ejemplo:**
```php
<?php echo esc_url( unsm_asset_url( 'imagenes/logo UNSM.png' ) ); ?>
```

### `unsm_navigation_menu()`
Muestra el menú de navegación principal de WordPress.

### `unsm_get_base_url()`
Obtiene la URL base del sitio (compatible con subdirectorios).

## Widgets

El tema incluye varias áreas de widgets:

1. **Sidebar Principal** - `sidebar-1`
2. **Footer 1** - `footer-1`
3. **Footer 2** - `footer-2`
4. **Footer 3** - `footer-3`

Para usar widgets:
1. Ve a **Apariencia > Widgets**
2. Arrastra widgets a las áreas disponibles

## Desarrollo

### Añadir Nuevos Templates

Para crear nuevas plantillas de página:

1. Crea un archivo PHP en la raíz del tema
2. Agrega el header del template:
```php
<?php
/**
 * Template Name: Nombre de la Plantilla
 */
get_header();
?>

<!-- Tu contenido aquí -->

<?php get_footer(); ?>
```

### Modificar Estilos

Los estilos están en `style.css`. Para hacer cambios:

1. Abre `style.css`
2. Busca la sección que deseas modificar
3. Guarda los cambios
4. Actualiza el navegador (Ctrl+F5)

### Modificar Scripts

El JavaScript principal está en `js/script.js`. Este archivo incluye:
- Funcionalidad del menú móvil
- Carruseles
- Interacciones de la página

## Solución de Problemas

### El tema no aparece en WordPress

**Solución:** Verifica que la carpeta del tema esté en:
```
wordpress/wp-content/themes/unsm-theme/
```

### Las imágenes no se cargan

**Solución:** Verifica que la carpeta `imagenes/` esté dentro del tema:
```
wordpress/wp-content/themes/unsm-theme/imagenes/
```

### El JavaScript no funciona

**Solución:** Verifica que `js/script.js` exista en:
```
wordpress/wp-content/themes/unsm-theme/js/script.js
```

### El menú móvil no funciona

**Solución:**
1. Verifica que `script.js` esté cargado (inspecciona la consola del navegador)
2. Limpia la caché del navegador
3. Verifica que no haya errores de JavaScript en la consola

## Soporte

Para reportar problemas o solicitar nuevas funcionalidades:

1. Revisa este archivo README
2. Verifica que todos los archivos estén en su lugar
3. Contacta al equipo de desarrollo web de la UNSM

## Créditos

- **Desarrollado por:** Universidad Nacional de San Martín
- **Versión:** 1.0.0
- **Última actualización:** Diciembre 2024

## Licencia

Este tema es propiedad de la Universidad Nacional de San Martín (UNSM).
GNU General Public License v2 or later.

---

**Universidad Nacional de San Martín - UNSM**
Jr. Maynas N° 177 - Morales, Tarapoto - San Martín - Perú
Teléfono: (+51) (042) 48 0159
Email: informes@unsm.edu.pe
Web: https://www.unsm.edu.pe
