<?php
// Archivo de prueba para verificar las rutas
require_once('wp-load.php');

echo "<h1>Test de Rutas UNSM</h1>";
echo "<h2>URLs Base:</h2>";
echo "<p><strong>WordPress Home URL:</strong> " . home_url() . "</p>";
echo "<p><strong>UNSM Base URL:</strong> " . unsm_get_base_url() . "</p>";

echo "<h2>Ejemplos de Rutas Generadas:</h2>";
echo "<ul>";

// Ejemplos de rutas
$test_paths = [
    'imagenes/logo UNSM.png',
    'nosotros/autoridades/indexAuto.php',
    'oficinas/rectorado/indexRecto.php',
    'facultades/ciencias agrarias/indexAgra.php',
    'admision/indexAdmin.php',
];

foreach ($test_paths as $path) {
    $url = unsm_asset_url($path);
    echo "<li><strong>$path</strong><br>";
    echo "URL: <a href='$url' target='_blank'>$url</a></li><br>";
}

echo "</ul>";

echo "<h2>Verificación:</h2>";
echo "<p>Las URLs deberían apuntar a <code>http://localhost:8080/unsm/...</code></p>";
echo "<p>Si ves <code>/wordpress/</code> en las URLs, hay un problema.</p>";
?>
