<?php
require_once('wp-load.php');

echo "<h2>Información de WordPress</h2>";
echo "<p><strong>Tema activo:</strong> " . wp_get_theme()->get('Name') . "</p>";
echo "<p><strong>Directorio del tema:</strong> " . get_template_directory() . "</p>";

// Verificar archivos del tema
$theme_dir = get_template_directory();
echo "<h3>Archivos del tema:</h3>";
echo "<ul>";
if (file_exists($theme_dir . '/single.php')) {
    echo "<li>✅ single.php (para posts individuales) - EXISTE</li>";
} else {
    echo "<li>❌ single.php - NO EXISTE</li>";
}
if (file_exists($theme_dir . '/index.php')) {
    echo "<li>✅ index.php - EXISTE</li>";
} else {
    echo "<li>❌ index.php - NO EXISTE</li>";
}
echo "</ul>";

// Probar permalink
$posts = get_posts(['numberposts' => 1]);
if (!empty($posts)) {
    $post = $posts[0];
    echo "<h3>Información del post de prueba:</h3>";
    echo "<p><strong>Título:</strong> " . $post->post_title . "</p>";
    echo "<p><strong>URL generada:</strong> <a href='" . get_permalink($post->ID) . "' target='_blank'>" . get_permalink($post->ID) . "</a></p>";
    echo "<p><strong>Estado:</strong> " . $post->post_status . "</p>";
}

// Verificar configuración de permalinks
echo "<h3>Configuración de Permalinks:</h3>";
echo "<p><strong>Estructura:</strong> " . get_option('permalink_structure') . "</p>";
?>
