# 🔧 Solución de Conflictos de Puertos en XAMPP

## 📋 Puertos que usa XAMPP

- **Apache:** Puerto 80 (HTTP) y 443 (HTTPS)
- **MySQL:** Puerto 3306

## ⚠️ Problema: Conflictos de Puertos

Si ves el mensaje: *"You need to uninstall/disable/reconfigure the blocking application"*, significa que otra aplicación está usando los mismos puertos.

## ✅ Soluciones

### Opción 1: Detener la aplicación que está usando el puerto (Recomendado)

#### Para el puerto 80 (Apache):
1. Abre el **Administrador de tareas** (Ctrl + Shift + Esc)
2. Ve a la pestaña **"Servicios"**
3. Busca y detén estos servicios que comúnmente usan el puerto 80:
   - **World Wide Web Publishing Service (W3SVC)** - Servicio IIS de Windows
   - **SQL Server Reporting Services**
   - **Skype** (a veces usa el puerto 80)
   - Cualquier otro servidor web

#### Para el puerto 3306 (MySQL):
1. Abre el **Administrador de tareas**
2. Busca procesos como:
   - **MySQL** (si tienes MySQL instalado por separado)
   - **MariaDB**
   - **Otros servicios de base de datos**

### Opción 2: Cambiar los puertos en XAMPP

Si no puedes detener la aplicación que está usando el puerto, puedes cambiar los puertos en XAMPP:

#### Cambiar puerto de Apache:
1. Abre el **Panel de Control de XAMPP**
2. Haz clic en **"Config"** junto a Apache
3. Selecciona **"httpd.conf"**
4. Busca la línea: `Listen 80`
5. Cámbiala a: `Listen 8080` (o cualquier puerto libre)
6. Guarda el archivo
7. Reinicia Apache

**Nota:** Si cambias el puerto, accede a tu sitio con:
- `http://localhost:8080/unsm/` en lugar de `http://localhost/unsm/`

#### Cambiar puerto de MySQL:
1. Abre el **Panel de Control de XAMPP**
2. Haz clic en **"Config"** junto a MySQL
3. Selecciona **"my.ini"**
4. Busca la línea: `port=3306`
5. Cámbiala a: `port=3307` (o cualquier puerto libre)
6. Guarda el archivo
7. Reinicia MySQL

**Importante:** Si cambias el puerto de MySQL, también debes actualizar `wp-config.php`:
```php
define( 'DB_HOST', 'localhost:3307' ); // Si cambias a puerto 3307
```

### Opción 3: Deshabilitar IIS (si está instalado)

Si tienes IIS (Internet Information Services) de Windows instalado:

1. Abre **"Activar o desactivar características de Windows"**
2. Desmarca **"Internet Information Services"**
3. Reinicia tu computadora
4. Intenta iniciar Apache en XAMPP nuevamente

### Opción 4: Usar netstat para identificar qué usa el puerto

Abre PowerShell o CMD como Administrador y ejecuta:

```powershell
# Para ver qué usa el puerto 80
netstat -ano | findstr :80

# Para ver qué usa el puerto 3306
netstat -ano | findstr :3306
```

Esto te mostrará el PID (Process ID) del proceso. Luego:
1. Abre el Administrador de tareas
2. Ve a "Detalles"
3. Busca el proceso con ese PID
4. Detén ese proceso

## 🔍 Verificar que los puertos están libres

Después de resolver el conflicto, verifica que los puertos están libres:

```powershell
# Verificar puerto 80
netstat -ano | findstr :80

# Verificar puerto 3306
netstat -ano | findstr :3306
```

Si no aparece nada, los puertos están libres.

## ✅ Configuración de WordPress

Una vez que Apache y MySQL estén funcionando correctamente, WordPress debería funcionar con la configuración actual:

- **URL de WordPress:** `http://localhost/unsm/wordpress/`
- **Base de datos:** `unsm_wordpress`
- **Host:** `localhost` (o `localhost:3306` si MySQL está en otro puerto)
- **Usuario:** `root`
- **Contraseña:** (vacía)

## 🎯 Pasos Rápidos Recomendados

1. **Detén IIS** (si está instalado):
   - Abre PowerShell como Administrador
   - Ejecuta: `net stop w3svc`

2. **Detén otros servicios MySQL**:
   - Busca en el Administrador de tareas procesos de MySQL
   - Detén los que no sean de XAMPP

3. **Reinicia XAMPP**:
   - Cierra el Panel de Control de XAMPP
   - Ábrelo de nuevo
   - Inicia Apache y MySQL

4. **Verifica que funcionan**:
   - Apache: `http://localhost/` debería mostrar la página de XAMPP
   - MySQL: Debería aparecer verde en el panel de control

## 📝 Nota Importante

Si cambias los puertos, recuerda actualizar:
- Las URLs en tu navegador
- La configuración de `wp-config.php` si cambias el puerto de MySQL
- Cualquier otra aplicación que use estos servicios

