# 📋 Instrucciones para Configurar WordPress - UNSM

## ✅ Pasos para Completar la Instalación

### 1. Crear la Base de Datos

**Opción A: Usando phpMyAdmin (Recomendado)**
1. Abre tu navegador y ve a: `http://localhost/phpmyadmin`
2. Haz clic en la pestaña **"SQL"**
3. Abre el archivo `crear_base_datos.sql` que está en la carpeta `wordpress/`
4. Copia todo el contenido del archivo
5. Pégalo en el área de texto de phpMyAdmin
6. Haz clic en **"Continuar"** o **"Ejecutar"**

**Opción B: Usando la línea de comandos MySQL**
```bash
mysql -u root -p < wordpress/crear_base_datos.sql
```

### 2. Verificar la Configuración

El archivo `wp-config.php` ya está creado con la siguiente configuración:
- **Base de datos:** `unsm_wordpress`
- **Usuario:** `root`
- **Contraseña:** (vacía - típico de XAMPP)
- **Host:** `localhost`

Si necesitas cambiar estos valores, edita el archivo `wordpress/wp-config.php`

### 3. Instalar WordPress

1. Abre tu navegador y ve a: `http://localhost:8080/unsm/wordpress/`
2. WordPress detectará que no está instalado y te mostrará el asistente de instalación
3. Completa el formulario con:
   - **Título del sitio:** Universidad Nacional de San Martín - UNSM
   - **Nombre de usuario:** (elige uno, por ejemplo: `admin`)
   - **Contraseña:** (elige una contraseña segura)
   - **Correo electrónico:** (tu correo)
4. Haz clic en **"Instalar WordPress"**

### 4. Acceder al Panel de Administración

Una vez instalado, puedes acceder al panel de administración en:
- **URL:** `http://localhost:8080/unsm/wordpress/wp-admin/`
- **Usuario:** El que creaste durante la instalación
- **Contraseña:** La que configuraste

### 5. Verificar la Integración

Después de instalar WordPress, todas tus páginas PHP ya están configuradas para cargar WordPress automáticamente. Puedes usar funciones de WordPress en cualquier página.

## 🔧 Solución de Problemas

### Error: "No se puede conectar a la base de datos"
- Verifica que MySQL esté corriendo en XAMPP
- Asegúrate de que la base de datos `unsm_wordpress` existe
- Verifica los datos en `wp-config.php`

### Error: "compat.php no encontrado"
- El archivo ya está creado en `wordpress/wp-includes/compat.php`
- Si persiste el error, verifica los permisos del archivo

### Error: "wp-load.php no encontrado"
- Verifica que la ruta en tus archivos PHP sea correcta
- La ruta relativa desde `index.php` es: `wordpress/wp-load.php`
- La ruta relativa desde `nosotros/` es: `../../wordpress/wp-load.php`
- La ruta relativa desde `contacto/` es: `../wordpress/wp-load.php`

## 📝 Notas Importantes

1. **Base de Datos Separada:** WordPress usa su propia base de datos (`unsm_wordpress`) que es diferente de la base de datos del formulario de contacto (`unsm_contacto`)

2. **Seguridad:** 
   - Cambia las claves secretas en `wp-config.php` después de la instalación
   - Usa contraseñas seguras para el administrador de WordPress
   - En producción, cambia `WP_DEBUG` a `false`

3. **URLs:** 
   - Las URLs están configuradas para usar el puerto 8080:
     - Dirección del sitio: `http://localhost:8080/unsm`
     - Dirección de WordPress: `http://localhost:8080/unsm/wordpress`
   - Si necesitas cambiarlas, edita `wp-config.php` o ve a: Ajustes > Generales en WordPress

## 🎉 ¡Listo!

Una vez completados estos pasos, WordPress estará completamente configurado e integrado en todas tus páginas PHP.

