# 🔧 Configuración de Puertos - UNSM WordPress

## 📋 Puertos Configurados

- **Apache:** Puerto **8080** (HTTP)
- **MySQL:** Puerto **3306**

## ✅ Configuración Actual

### WordPress (`wp-config.php`)
- **WP_HOME:** `http://localhost:8080/unsm`
- **WP_SITEURL:** `http://localhost:8080/unsm/wordpress`
- **DB_HOST:** `localhost:3306`
- **DB_NAME:** `unsm_wordpress`
- **DB_USER:** `root`
- **DB_PASSWORD:** (vacía)

## 🌐 URLs de Acceso

### Páginas del Sitio
- **Página Principal:** `http://localhost:8080/unsm/`
- **Historia:** `http://localhost:8080/unsm/nosotros/historia/historia.php`
- **Contacto:** `http://localhost:8080/unsm/contacto/indexContac.php`
- **Misión:** `http://localhost:8080/unsm/nosotros/mision/indexMision.php`

### WordPress
- **Instalación de WordPress:** `http://localhost:8080/unsm/wordpress/`
- **Panel de Administración:** `http://localhost:8080/unsm/wordpress/wp-admin/`
- **Login:** `http://localhost:8080/unsm/wordpress/wp-login.php`

## 📝 Notas Importantes

1. **Siempre usa el puerto 8080** al acceder a las páginas del sitio
2. **MySQL está en el puerto 3306** (puerto por defecto, no necesita especificarse en la URL)
3. Si cambias los puertos en XAMPP, actualiza las URLs en `wp-config.php`

## 🔄 Si Necesitas Cambiar los Puertos

### Cambiar puerto de Apache en XAMPP:
1. Abre el Panel de Control de XAMPP
2. Haz clic en **"Config"** junto a Apache
3. Selecciona **"httpd.conf"**
4. Busca: `Listen 8080`
5. Cámbialo al puerto que desees
6. Actualiza `WP_HOME` y `WP_SITEURL` en `wp-config.php`

### Cambiar puerto de MySQL en XAMPP:
1. Abre el Panel de Control de XAMPP
2. Haz clic en **"Config"** junto a MySQL
3. Selecciona **"my.ini"**
4. Busca: `port=3306`
5. Cámbialo al puerto que desees
6. Actualiza `DB_HOST` en `wp-config.php` a: `localhost:NUEVO_PUERTO`

## ✅ Verificación

Para verificar que todo está funcionando:

1. **Apache:** Abre `http://localhost:8080/` - Deberías ver la página de XAMPP
2. **MySQL:** En el Panel de Control de XAMPP, MySQL debería estar en verde
3. **WordPress:** Después de crear la base de datos, ve a `http://localhost:8080/unsm/wordpress/`

