<?php
// Archivo de prueba para verificar la integración de WordPress
require_once(__DIR__ . '/wordpress/wp-load.php');

echo "<h1>Test de Integración WordPress</h1>";

$args = array(
    'post_type'      => 'post',
    'posts_per_page' => 3,
    'post_status'    => 'publish'
);

$query = new WP_Query($args);

echo "<p><strong>Total de posts encontrados:</strong> " . $query->found_posts . "</p>";

if ($query->have_posts()) {
    echo "<h2>Posts disponibles:</h2>";
    echo "<ul>";
    while ($query->have_posts()) {
        $query->the_post();
        echo "<li>";
        echo "<strong>" . get_the_title() . "</strong><br>";
        echo "Fecha: " . get_the_date() . "<br>";
        echo "Tiene imagen: " . (has_post_thumbnail() ? 'Sí' : 'No') . "<br>";
        echo "Extracto: " . wp_trim_words(get_the_excerpt(), 15, '...') . "<br>";
        echo "URL: " . get_permalink();
        echo "</li><br>";
    }
    echo "</ul>";
} else {
    echo "<p style='color: red;'>No se encontraron posts publicados.</p>";
}

wp_reset_postdata();

echo "<hr>";
echo "<p><a href='/unsm/'>← Volver al sitio principal</a></p>";
?>
