<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Historia de la Universidad Nacional de San Martín - UNSM en Tarapoto, Perú. Origen y proceso de nuestra universidad.">
    <meta name="keywords" content="UNSM, historia UNSM, universidad San Martín, educación superior Tarapoto, universidad Perú">
    <meta name="author" content="Universidad Nacional de San Martín">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#359444">
    
    <title>Historia de la UNSM - Universidad Nacional de San Martín</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../imagenes/escudo unsm.png" sizes="48x48">
    <link rel="apple-touch-icon" href="../../imagenes/escudo unsm.png">
    
    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../css/style.css">
    <!-- Stylesheet Historia -->
    <link rel="stylesheet" href="css/styleHis.css">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en Facebook" aria-label="Página oficial de Facebook de la UNSM">
                    <img src="../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Síguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Síguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../imagenes/logo telefono.png" alt="Teléfono" class="contact-icon" width="18" height="18"> 
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18"> 
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../" aria-label="Ir a la página principal de UNSM">
                    <img src="../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martín" width="auto" height="70">
                </a>
            </div>

            <!-- Botón Hamburguesa para móvil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menú de navegación" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>
            
            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">
                
                <!-- Logo en menú móvil -->
                <div class="mobile-nav-logo">
                    <img src="../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="../../#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menú Nosotros">
                            <li><a href="../autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="./">Historia de la Universidad</a></li>
                            <li><a href="../mision/indexMision.php">Nuestra Misión y Visión</a></li>
                            <li><a href="../mision/objetivos/">Objetivos</a></li>
                            <li><a href="../onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../himno/indexHimno.php">Himno</a></li>
                            <li><a href="../directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../calendarioAcade/indexCale.php">Calendario Acad&eacute;mico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="../../#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Académico</a></li>
                                <li><a href="../../oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigación</a></li>
                                <li><a href="../../oficinas/secretaria general/indexSecreGene.php">Secretaría General</a></li>
                                <li><a href="../../oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../../oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../../oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicación e Imagen Institucional</a></li>
                                <li><a href="../../#cooperacion">Cooperación y Relaciones Internacionales</a></li>
                                <li><a href="../../#control">Órgano de Control Institucional</a></li>
                                <li><a href="../../#ejecutora">Ejecutora de Inversiones</a></li>
                                <li><a href="../../#asesoria">Asesoría Jurídica</a></li>
                                <li><a href="../../#grados">Grados y Títulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Académicas</li>
                                <li><a href="../../#admision">Oficina de Admisión</a></li>
                                <li><a href="../../#asuntos-academicos">Asuntos Académicos</a></li>
                                <li><a href="../../#seguimiento">Seguimiento al Egresado e Inserción Laboral</a></li>
                                <li><a href="../../#tecnologias">Tecnologías de la Información</a></li>
                                <li><a href="../../#incubadora">Incubadora de Empresas</a></li>
                                <li><a href="../../#fondo-editorial">Fondo Editorial</a></li>
                                <li><a href="../../#comite-electoral">Comité Electoral Universitario</a></li>
                                <li><a href="../../#innovacion">Innovación y Transferencia Tecnológica</a></li>
                                <li><a href="../../#produccion">Producción de Bienes y Servicios</a></li>
                                <li><a href="../../#responsabilidad">Responsabilidad Social Universitaria</a></li>
                                <li><a href="../../#servicios-generales">Servicios Generales</a></li>
                                <li><a href="../../#bienestar">Bienestar Universitario</a></li>
                                <li><a href="../../#defensoria">Defensoría Universitaria</a></li>
                                <li><a href="../../#calidad">Gestión de la Calidad</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../#admision">ADMISIÓN</a></li>
                    <li><a href="../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menú Facultades">
                            <li class="has-submenu">
                                <a href="../../#ciencias-agrarias" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../#agronomia">Agronomía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="../../#obstetricia">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../../#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingeniería Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Agroindustrial">
                                    <li><a href="../../#ing-agroindustrial">Ingeniería Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingeniería Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Civil y Arquitectura">
                                    <li><a href="../../#arquitectura">Arquitectura</a></li>
                                    <li><a href="../../#ingenieria-civil-carrera">Ingeniería Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingeniería de Sistemas e Informática</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería de Sistemas">
                                    <li><a href="../../#ing-sistemas">Ingeniería de Sistemas e Informática</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ecologia" aria-haspopup="true" aria-expanded="false">Ecología</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecología">
                                    <li><a href="../../#ing-ambiental">Ingeniería Ambiental</a></li>
                                    <li><a href="../../#ing-sanitaria">Ingeniería Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Políticas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="../../#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="../../#medicina-humana-carrera">Medicina Humana</a></li>
                                    <li><a href="../../#enfermeria">Enfermería</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Económicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Económicas">
                                    <li><a href="../../#administracion">Administración</a></li>
                                    <li><a href="../../#contabilidad">Contabilidad</a></li>
                                    <li><a href="../../#economia">Economía</a></li>
                                    <li><a href="../../#turismo">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#educacion" aria-haspopup="true" aria-expanded="false">Educación y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educación">
                                    <li><a href="../../#educacion-inicial">Educación Inicial</a></li>
                                    <li><a href="../../#educacion-primaria">Educación Primaria</a></li>
                                    <li><a href="../../#educacion-secundaria">Educación Secundaria</a></li>
                                    <li><a href="../../#idiomas">Idiomas</a></li>
                                    <li>
                                        <a href="../../#psicologia">
                                            Psicología 
                                            <span class="badge-nuevo">Nuevo</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="../../#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Menú Transparencia">
                            <li><a href="../../#licenciamiento">Licenciamiento</a></li>
                            <li><a href="../../#institucional">Institucional Ley 30220</a></li>
                            <li><a href="../../#estandar">Estándar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>
                
                <!-- Logos gob.pe dentro del menú móvil -->
                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Perú">
                        <img src="../../imagenes/logo gobPe.png" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Perú">
                    <img src="../../imagenes/logo gobPe.png" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Contenido Principal -->
    <main id="main-content">
        <!-- Hero Section -->
        <section class="hero historia-hero">
            <div class="hero-content">
                <h1>Historia de la Universidad Nacional de San Martín</h1>
                <p>Origen y proceso de nuestra universidad</p>
            </div>
        </section>

        <!-- Sección de Historia -->
        <section class="content-section historia-section">
            <div class="content-wrapper">
                <h2 class="section-title">Reseña Histórica</h2>
                <div class="section-divider" aria-hidden="true"></div>
                
                <div class="historia-content">
                    <div class="historia-text">
                        <p>La Universidad Nacional de San Martín, Pionera Casa Superior de Estudios en la Región San Martín, fue creada por <strong>Decreto Ley Nº 22803</strong> el <strong>18 de diciembre de 1979</strong>, en el gobierno del Presidente de la República, General de División Ejército Peruano Francisco Morales Bermúdez Cerruti, como consecuencia de la lucha del pueblo sanmartinense, por obtener una institución educativa con nivel universitario en la región.</p>
                        
                        <p>El <strong>16 de diciembre de 1980</strong>, con Resolución Nº 756-80-CONAI del Consejo Nacional Interuniversitario se nombra la primera la Comisión de Gobierno de la Universidad Nacional de San Martín, presidida por el Ing. Raúl Ríos Reátegui, como miembros el Prof. Dalín Omar Encomenderos Dávalos y el Blgo. Raúl Espíritu Cavero.</p>
                        
                        <p>El <strong>26 de enero de 1981</strong> se declara a la ciudad de Tarapoto como sede de la Universidad Nacional de San Martín, con Resolución Nº 905-81-CONAI de la Comisión Nacional Interuniversitaria, se acuerda que la ciudad de Tarapoto, reúne los requisitos necesarios para ser designada como sede de la Universidad, estando a lo acordado en sesión del día 20 de enero de 1981 con Decreto Ley Nº 22803, se ratifica la creación de la Universidad con Ley Nº 23261 el <strong>18 de julio de 1981</strong>.</p>
                        
                        <p>Con fecha <strong>09 de noviembre de 1981</strong> se formó la primera Comisión Central de Admisión con Resolución Nº 148-81-CG-UNSM, que inicia sus labores académicas y administrativas a partir del 09 de octubre hasta al 24 de noviembre y fue integrada por los siguientes docentes de la Universidad Nacional de Ingeniería: Ing. Luz Espinoza Canales como Presidente, y como miembros el Dr. Humberto Asmat Azahuanche y Lic. Mauro Chumpitaz Reyna.</p>
                        
                        <p>Con Resolución Nº 187-81-CG-UNSM de fecha <strong>30 de noviembre de 1981</strong>, se aprueba la relación de ingresantes en los cuatro (04) programas académicos: Agronomía, Ingeniería Agroindustrial, Obstetricia e Ingeniería Civil; la Resolución Nº102-82-CG-UNSM, de fecha <strong>23 de abril de 1982</strong> aprueba el Calendario Académico correspondiente al primer semestre 1982–l de la Universidad Nacional de San Martín, iniciándose las clases el <strong>17 de mayo de 1982</strong>.</p>
                        
                        <p>En el año <strong>1986</strong>, para continuar con las gestiones académicas y administrativas en la Universidad se forma la segunda Comisión, denominada Comisión Organizadora, con Resolución Nº 894-86-ANR, de fecha 17 de junio de la Asamblea Nacional de Rectores y fueron designados los siguientes docentes: como presidente el Ing. Augusto Bacco Montes Gutiérrez, como Vicepresidente Académica la Dra. Felicita Chang Say Yon, y Vicepresidente Administrativo el Dr. Jorge Barsallo Guerrero.</p>
                        
                        <p>En el año <strong>1993</strong>, se elige al Primer Rector y Vicerrectores, con Resolución N° 346-93-UNSM/CO se reconoce los resultados, se elige como primer Rector al Dr. Jorge Gonzales Ramírez, quien ejerce sus funciones desde el 15 de setiembre, pero renuncia antes de cumplir los 5 años de gobierno y asume el cargo de Rector Interino a partir del <strong>06 de diciembre de 1996</strong>, el profesor Dalín Omar Encomenderos Dávalos, quien era Vicerrector Académico y como Vicerrector Administrativo el Ing. M.Sc. Pardo Miguel Moncada Mori.</p>
                        
                        <p>En el año <strong>1997</strong>, con Resolución N° 094-97-UNSM/R de fecha 28 de febrero es proclamado el Lic. M. Sc. Marco Armando Gálvez Díaz como nuevo Rector de la Universidad Nacional de San Martín, a partir del 01 de marzo de 1997, por el periodo de cinco años, que no llegó a completarlos, por encontrase la Universidad en conflictos. En el año <strong>1998</strong>, con Resolución N° 822-98-UNSM/R de fecha 17 de diciembre se reconoce al Ing. M.Sc. Alejandro Cruz Rengifo como Vicerrector Académico y al Dr. Jorge Sandoval Rojas como Vicerrector Administrativo.</p>
                        
                        <p>En el año <strong>2003</strong>, la Asamblea Nacional de Rectores con Resolución N°998-2003-ANR del 10 de enero, resuelve declarar en proceso de reorganización a la Universidad Nacional de San Martín y designa una Comisión de Reorganización y de Gobierno, conformada por el docente de la Universidad Nacional de Piura Lic. Arturo Ruiz Chapilliquén como Presidente, Ing. Ricardo García Pinchi como Vice Presidente Académico y al Ing. Armando Cano Echevarría como Vicepresidente Administrativo.</p>
                        
                        <p>El <strong>29 de agosto del 2003</strong>, y con Resolución N° 1108-2003-UNSM/CRyG-ANR se aprueba los resultados de la elección de las siguientes Autoridades Universitarias: como Rector el Ing. M.Sc. Alfredo Quinteros García, como Vicerrector Académico el Ing. M.Sc. Abner Milán Barzola Cárdenas y Vicerrector Administrativo el Econ. M.Sc. Réniger Sousa Fernández, asumiendo sus funciones a partir del 29 de agosto del mismo año, quienes cumplieron el periodo de cinco (5) años de gobierno.</p>
                        
                        <p>En el año <strong>2008</strong>, la Asamblea Universitaria con Resolución N° 003-2008-UNSM/AU-R del 27 de agosto de 2008, aprueba los resultados de las elecciones, reeligiéndose nuevamente como rector el Ing. M.Sc. Alfredo Quinteros García, en este segundo periodo de gestión acompañado del Ing. M.Sc. Julio Armando Ríos Ramírez como Vicerrector Académico y el Ing. M.Sc. Jorge Sánchez Ríos como Vicerrector Administrativo; quienes asumieron el compromiso de seguir forjando el desarrollo de la Universidad, cumpliendo los cinco (5) años de gobierno, del <strong>31 de agosto del 2008 al 30 de agosto del 2013</strong>.</p>
                        
                        <p>El <strong>07 de agosto del año 2013</strong>, asume como nuevo y quinto rector en la historia de la universidad, el Dr. Julio Armando Ríos Ramírez con Resolución Nº 009-2013-UNSM/AU, como Vicerrectora Académica a la Dra. Evangelina Ampuero Fernández con Resolución Nº 010-2013-UNSM/AU-R y como Vicerrectora Administrativa a la Dra. Nelly Reátegui Lozano con Resolución Nº 011-2013-UNSM/AU-R, quienes iniciaron sus funciones a partir del 31 de agosto del año 2013, más no lograron culminar su periodo de gobierno, a causa de la entrada en vigencia de la nueva Ley Universitaria 30220.</p>
                        
                        <p>En el año <strong>2014</strong>, para la implementación de la Ley Universitaria Nº 30220, mediante voto universal, se elige como Rector al Dr. Aníbal Quinteros García, reconocido con Resolución Nº 003-2014-AUT/UNSM-T, le acompañan en esta gestión como Vicerrector Académico el Dr. Óscar Mendieta Taboada y la Vicerrectora de Investigación la Dra. Anita Ruth Mendiola Céspedes, con Resolución Nº 004-2014-AUT/UNSM-T. Con Resolución Nº 005-2018-UNSM/AU-R/NLU de fecha 02 de agosto del año 2018, se reconoce el periodo de gobierno a partir del <strong>27 de marzo del 2015 al 26 de marzo del 2020</strong>.</p>
                        
                        <p>El <strong>1 de mayo de 2019</strong> con Resolución de Consejo Directivo Nº 055-2019-SUNEDU/CD., la Superintendencia Nacional de Educación Superior Universitaria (Sunedu) otorgó la Licencia Institucional a la Universidad Nacional de San Martín (UNSM), en el marco de la Ley Universitaria Nº 30220, suceso que marcó un hito histórico en la vida universitaria, permitiendo a la institución continuar brindando los servicios universitarios con el cumplimiento de las condiciones básicas de calidad y enmarcadas en el proceso de la mejora continua de la enseñanza y la formación profesional.</p>
                        
                        <p>En <strong>octubre del año 2019</strong>, después de un proceso de elecciones universitarias se eligió democráticamente a las nuevas autoridades universitarias, reconociendo mediante Resolución Nº 1042-2019-UNSM/CU-R al Dr. Aquilino Mesías García Bautista como rector, a la Dra. Rossana Herminia Hidalgo Pozzi como vicerrectora académica y a la Dra. Alicia Bartra Reátegui como vicerrectora de investigación, quienes iniciaron su periodo de gobierno el <strong>26 de marzo del 2020</strong> y culminaron el <strong>26 de marzo del 2025</strong>.</p>
                        
                        <p>En la actualidad, gracias a un proceso democrático realizado en <strong>noviembre del 2024</strong>, fueron elegidas las nuevas autoridades universitarias para el periodo <strong>2025 - 2030</strong>, con el liderazgo del Dr. Ricardo Raúl Layza Castañeda en calidad de rector, del Dr. Marco Armando Gálvez Díaz como vicerrector académico y de la Dra. Dahpne Viena Oliveira como vicerrectora de investigación, quienes mantienen el firme compromiso de trabajar por el bienestar de la comunidad de la Universidad Nacional de San Martín.</p>
                        
                        <p>Nuestras autoridades universitarias a través del tiempo, viendo la necesidad de brindar mayores oportunidades en educación superior, crearon hasta la fecha diez (11) Facultades y veinte (21) Escuelas Profesionales.</p>
                        
                        <p>En la actualidad nuestras carreras profesionales son: Agronomía, Medicina Veterinaria, Ingeniería Agroindustrial, Ingeniería Civil, Arquitectura, Obstetricia, Enfermería, Economía, Contabilidad, Administración, Turismo, Idiomas, Educación Inicial, Educación Secundaria, Educación Primaria, Ingeniería de Sistemas e Informática, Ingeniería Ambiental, Ingeniería Sanitaria, Medicina Humana, Derecho y Psicología.</p>
                        
                        <p>La Universidad Nacional de San Martín es un centro de estudios superiores de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos, con responsabilidad social y comprometida con el desarrollo local, regional y nacional, mediante la generación de conocimientos, tecnología e innovación, en el marco de una cultura de valores, proceso de acreditación y de actualización permanente.</p>
                        
                        <p>Han transcurrido <strong>46 años</strong> formando profesionales que hoy generan cambios y desarrollo en San Martín y el país, colaborando y compartiendo conocimientos basados en la investigación científica. Las autoridades universitarias integradas por el rector Dr. Ricardo Raúl Layza Castañeda, vicerrector académico Dr. Marco Armando Gálvez Díaz y vicerrectora de investigación Dra. Dahpne Viena Oliveira, están comprometidos en seguir construyendo una universidad líder en la Amazonía peruana con calidad educativa al servicio de la sociedad.</p>
                        
                        <p class="historia-firma"><em>Oficina de Comunicación e Imagen Institucional.</em></p>
                    </div>
                    
                    <div class="historia-image">
                        <img src="../../imagenes/historia/historia-unsm.png" alt="Historia de la Universidad Nacional de San Martín" loading="lazy">
                    </div>
                </div>
            </div>
        </section>
    </main>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central Telefónica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>
            
            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="../../#admision">Admisión</a></li>
                    <li><a href="../../#facultades">Facultades</a></li>
                    <li><a href="../../#posgrado">Posgrado</a></li>
                    <li><a href="../../#investigacion">Investigación</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../../#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../../#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../../#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../../#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../../#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Martín - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                    <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <script src="../../js/script.js" defer></script>
    <script src="js/sriptHis.js" defer></script>
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>
</body>
</html>
