/**
 * Script para el Directorio Institucional
 * Maneja la interactividad del menu lateral y botones de descarga
 */

document.addEventListener('DOMContentLoaded', function() {

    // Inicializar menu del directorio
    initDirectoryMenu();

    // Inicializar boton de descarga
    initDownloadButton();

});

/**
 * Inicializa la funcionalidad del menu lateral
 */
function initDirectoryMenu() {
    const menuButtons = document.querySelectorAll('.menu-button');

    menuButtons.forEach(button => {
        button.addEventListener('click', function() {
            // Toggle estado expandido
            const isExpanded = this.getAttribute('aria-expanded') === 'true';

            // Cerrar todos los demas items
            menuButtons.forEach(btn => {
                btn.setAttribute('aria-expanded', 'false');
                btn.closest('.menu-item').classList.remove('active');
            });

            // Toggle el item actual
            if (!isExpanded) {
                this.setAttribute('aria-expanded', 'true');
                this.closest('.menu-item').classList.add('active');

                // Aqui puedes agregar logica para cargar contenido dinamico
                const menuText = this.querySelector('.menu-text').textContent;
                loadDirectoryContent(menuText);
            } else {
                this.setAttribute('aria-expanded', 'false');
                this.closest('.menu-item').classList.remove('active');
            }
        });

        // Soporte para navegacion con teclado
        button.addEventListener('keydown', function(e) {
            if (e.key === 'Enter' || e.key === ' ') {
                e.preventDefault();
                this.click();
            }
        });
    });
}

/**
 * Carga el contenido correspondiente a la seccion seleccionada
 * @param {string} sectionName - Nombre de la seccion seleccionada
 */
function loadDirectoryContent(sectionName) {
    const contentArea = document.querySelector('.content-info');

    if (!contentArea) return;

    // Efecto de transicion
    contentArea.style.opacity = '0';

    setTimeout(() => {
        // Aqui puedes agregar contenido especifico para cada seccion
        contentArea.innerHTML = '<h2 style="color: #359444; margin-bottom: 15px; font-size: 1.5rem;">' +
                sectionName +
            '</h2>' +
            '<p style="margin-bottom: 10px;">' +
                'Informaci&oacute;n detallada sobre <strong>' + sectionName + '</strong>.' +
            '</p>' +
            '<p>' +
                'Puede descargar el directorio completo haciendo clic en el bot&oacute;n &quot;Descargar&quot; arriba.' +
            '</p>';

        contentArea.style.opacity = '1';
    }, 200);
}

/**
 * Inicializa la funcionalidad del boton de descarga
 */
function initDownloadButton() {
    const downloadBtn = document.querySelector('.btn-download');

    if (!downloadBtn) return;

    downloadBtn.addEventListener('click', function() {
        // Aqui puedes agregar la URL del archivo a descargar
        const downloadUrl = '#'; // Reemplazar con la URL real del PDF/documento

        if (downloadUrl === '#') {
            alert('El documento de descarga estar\u00E1 disponible pr\u00F3ximamente.');
            return;
        }

        // Descargar archivo
        window.open(downloadUrl, '_blank');

        // Feedback visual
        const originalText = this.innerHTML;
        this.innerHTML = '<span class="download-icon">&#11015;</span> Descargando...';
        this.disabled = true;

        setTimeout(() => {
            this.innerHTML = originalText;
            this.disabled = false;
        }, 2000);
    });
}

/**
 * Funcion auxiliar para manejar descarga de archivos
 * @param {string} url - URL del archivo a descargar
 * @param {string} filename - Nombre del archivo
 */
function downloadFile(url, filename) {
    const link = document.createElement('a');
    link.href = url;
    link.download = filename || 'directorio-institucional-unsm.pdf';
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}

/**
 * Maneja el scroll suave del menu lateral en moviles
 */
function handleMobileScroll() {
    const sidebar = document.querySelector('.directory-sidebar');

    if (window.innerWidth <= 768) {
        sidebar.style.position = 'static';
    } else {
        sidebar.style.position = 'sticky';
    }
}

// Listener para redimensionamiento de ventana
window.addEventListener('resize', handleMobileScroll);

// Ejecutar al cargar
handleMobileScroll();
