/**
 * Script para el Calendario Academico
 * Maneja la interactividad del menu lateral y carga de PDFs
 */

document.addEventListener('DOMContentLoaded', function() {

    // Inicializar menu del calendario
    initCalendarMenu();

    // Cargar el primer año por defecto (2026)
    loadCalendarYear('2026');

});

/**
 * Inicializa la funcionalidad del menu lateral de años
 */
function initCalendarMenu() {
    const yearButtons = document.querySelectorAll('.year-button');

    yearButtons.forEach(button => {
        button.addEventListener('click', function() {
            const yearItem = this.closest('.year-item');
            const year = yearItem.getAttribute('data-year');

            // Remover clase active de todos los items
            document.querySelectorAll('.year-item').forEach(item => {
                item.classList.remove('active');
            });

            // Agregar clase active al item seleccionado
            yearItem.classList.add('active');

            // Cargar el calendario del año seleccionado
            loadCalendarYear(year);
        });

        // Soporte para navegacion con teclado
        button.addEventListener('keydown', function(e) {
            if (e.key === 'Enter' || e.key === ' ') {
                e.preventDefault();
                this.click();
            }
        });
    });
}

/**
 * Carga el calendario academico del año seleccionado
 * @param {string} year - Año del calendario a cargar
 */
function loadCalendarYear(year) {
    const pdfViewer = document.getElementById('pdfViewer');
    const noDocument = document.querySelector('.no-document');

    // Ocultar el mensaje de "no documento"
    if (noDocument) {
        noDocument.style.display = 'none';
    }

    // Mostrar el visor de PDF
    if (pdfViewer) {
        pdfViewer.style.display = 'block';

        // Aqui puedes definir las rutas de los PDFs para cada año
        // Por ahora usaremos rutas de ejemplo
        const pdfUrls = {
            '2026': 'pdf/calendario-2026.pdf',
            '2025': 'pdf/calendario-2025.pdf',
            '2024': 'pdf/calendario-2024.pdf',
            '2023': 'pdf/calendario-2023.pdf',
            '2022': 'pdf/calendario-2022.pdf',
            '2021': 'pdf/calendario-2021.pdf',
            '2020': 'pdf/calendario-2020.pdf',
            '2019': 'pdf/calendario-2019.pdf',
            '2018': 'pdf/calendario-2018.pdf',
            '2017': 'pdf/calendario-2017.pdf',
            '2016': 'pdf/calendario-2016.pdf'
        };

        const pdfUrl = pdfUrls[year];

        if (pdfUrl) {
            // Cargar el PDF en el iframe
            pdfViewer.src = pdfUrl;
        } else {
            // Si no hay PDF disponible, mostrar mensaje
            if (noDocument) {
                noDocument.style.display = 'flex';
                noDocument.querySelector('p').textContent =
                    'El calendario acad\u00E9mico para el a\u00F1o ' + year + ' no est\u00E1 disponible a\u00FAn.';
            }
            pdfViewer.style.display = 'none';
        }
    }
}

/**
 * Maneja el scroll suave del menu lateral en moviles
 */
function handleMobileScroll() {
    const sidebar = document.querySelector('.calendar-sidebar');

    if (window.innerWidth <= 768) {
        sidebar.style.position = 'static';
    } else {
        sidebar.style.position = 'sticky';
    }
}

// Listener para redimensionamiento de ventana
window.addEventListener('resize', handleMobileScroll);

// Ejecutar al cargar
handleMobileScroll();
