<?php
session_start();

// Si el usuario ya está autenticado, redirigir al dashboard
if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
    header('Location: dashboard.php');
    exit;
}

// Procesar el login
$error_message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once 'auth/authenticate.php';

    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error_message = 'Por favor, complete todos los campos.';
    } else {
        $auth_result = authenticate_user($username, $password);

        if ($auth_result['success']) {
            $_SESSION['user_logged_in'] = true;
            $_SESSION['user_id'] = $auth_result['user_id'];
            $_SESSION['username'] = $auth_result['username'];
            $_SESSION['user_role'] = $auth_result['role'];

            header('Location: dashboard.php');
            exit;
        } else {
            $error_message = $auth_result['message'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Sistema de Login - Universidad Nacional de San Martín">
    <meta name="robots" content="noindex, nofollow">
    <title>Iniciar Sesión - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet -->
    <link rel="stylesheet" href="css/login.css">
</head>
<body>
    <div class="login-container">
        <!-- Panel Izquierdo - Información -->
        <div class="login-panel-left">
            <div class="login-branding">
                <img src="imagenes/logo UNSM.png" alt="Universidad Nacional de San Martín" class="login-logo">
                <h1>Universidad Nacional de San Martín</h1>
                <p class="subtitle">Sistema de Gestión Académica</p>
                <div class="branding-decoration"></div>
            </div>
        </div>

        <!-- Panel Derecho - Formulario -->
        <div class="login-panel-right">
            <div class="login-form-container">
                <div class="login-header">
                    <h2>Iniciar Sesión</h2>
                    <p>Ingrese sus credenciales para acceder al sistema</p>
                </div>

                <?php if (!empty($error_message)): ?>
                    <div class="alert alert-error" role="alert">
                        <svg class="alert-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="12" cy="12" r="10"></circle>
                            <line x1="12" y1="8" x2="12" y2="12"></line>
                            <line x1="12" y1="16" x2="12.01" y2="16"></line>
                        </svg>
                        <span><?php echo htmlspecialchars($error_message); ?></span>
                    </div>
                <?php endif; ?>

                <form action="login.php" method="POST" class="login-form" id="loginForm">
                    <!-- Campo Usuario -->
                    <div class="form-group">
                        <label for="username" class="form-label">
                            <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                <circle cx="12" cy="7" r="4"></circle>
                            </svg>
                            Usuario
                        </label>
                        <input
                            type="text"
                            id="username"
                            name="username"
                            class="form-input"
                            placeholder="Ingrese su usuario"
                            value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>"
                            required
                            autocomplete="username"
                            autofocus
                        >
                    </div>

                    <!-- Campo Contraseña -->
                    <div class="form-group">
                        <label for="password" class="form-label">
                            <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                                <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                            </svg>
                            Contraseña
                        </label>
                        <div class="password-input-wrapper">
                            <input
                                type="password"
                                id="password"
                                name="password"
                                class="form-input"
                                placeholder="Ingrese su contraseña"
                                required
                                autocomplete="current-password"
                            >
                            <button type="button" class="password-toggle" aria-label="Mostrar contraseña" id="togglePassword">
                                <svg class="eye-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                    <circle cx="12" cy="12" r="3"></circle>
                                </svg>
                            </button>
                        </div>
                    </div>

                    <!-- Recordar sesión y Olvidé mi contraseña -->
                    <div class="form-options">
                        <label class="checkbox-label">
                            <input type="checkbox" name="remember" id="remember">
                            <span class="checkbox-custom"></span>
                            <span>Recordar sesión</span>
                        </label>
                        <a href="recuperar-password.php" class="link-forgot">¿Olvidaste tu contraseña?</a>
                    </div>

                    <!-- Botón de Envío -->
                    <button type="submit" class="btn-login">
                        <span class="btn-text">Iniciar Sesión</span>
                        <svg class="btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M15 3h4a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2h-4"></path>
                            <polyline points="10 17 15 12 10 7"></polyline>
                            <line x1="15" y1="12" x2="3" y2="12"></line>
                        </svg>
                    </button>
                </form>

                <div class="login-footer">
                    <p>¿No tienes una cuenta? <a href="registro.php" class="link-register">Regístrate aquí</a></p>
                </div>

                <!-- Volver al inicio -->
                <div class="back-to-home">
                    <a href="index.php" class="link-home">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                        </svg>
                        Volver al inicio
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="js/login.js"></script>
</body>
</html>
