/**
 * CHATBOT DATA - Universidad Nacional de San Martín
 * Base de datos de preguntas frecuentes y configuración
 * Última actualización: 2025-12-23
 */

const CHATBOT_DATA = {
    // ============================================
    // CONFIGURACIÓN
    // ============================================
    config: {
        confidenceThreshold: 0.3,     // 30% de coincidencia requerida (ajustado para frases cortas)
        typingDelay: 800,              // ms antes de que el bot responda
        messageMaxLength: 500,         // caracteres máximos por mensaje
        maxRelatedQuestions: 3,        // máximo de preguntas relacionadas a mostrar
    },

    // ============================================
    // ROLES DE USUARIO
    // ============================================
    roles: {
        estudiante: {
            id: 'estudiante',
            name: 'Estudiante',
            icon: '🎓',
            description: 'Soy estudiante de la UNSM'
        },
        docente: {
            id: 'docente',
            name: 'Docente',
            icon: '👨‍🏫',
            description: 'Soy docente de la UNSM'
        },
        administrativo: {
            id: 'administrativo',
            name: 'Administrativo',
            icon: '💼',
            description: 'Trabajo en área administrativa'
        },
        visitante: {
            id: 'visitante',
            name: 'Postulante',
            icon: '👤',
            description: 'Quiero estudiar en la UNSM'
        }
    },

    // ============================================
    // CATEGORÍAS Y FAQs
    // ============================================
    categories: {
        admision: {
            id: 'admision',
            name: 'Admisión e Inscripción',
            icon: '📚',
            color: '#359444',
            description: 'Información sobre el proceso de admisión, requisitos y costos',
            faqs: [
                {
                    id: 'adm-001',
                    question: '¿Cuándo inicia el proceso de admisión?',
                    answer: 'El proceso de admisión 2026-I inicia el 15 de enero de 2026 y se extiende hasta el 28 de febrero de 2026. Puedes inscribirte en línea a través de nuestra página web o presencialmente en nuestras oficinas ubicadas en Jr. Amorarca N° 315, Morales, de lunes a viernes de 8:00 AM a 5:00 PM.',
                    keywords: ['cuando', 'fecha', 'inicio', 'admision', 'inscripcion', 'comienza', 'empieza', 'cronograma', 'calendario'],
                    relatedFaqs: ['adm-002', 'adm-003', 'adm-004']
                },
                {
                    id: 'adm-002',
                    question: '¿Cuáles son los requisitos para postular?',
                    answer: 'Los requisitos básicos son:\n\n• Certificado de estudios original de secundaria\n• Partida de nacimiento original\n• Copia del DNI vigente\n• Dos fotografías tamaño carnet fondo blanco\n• Recibo de pago por derecho de inscripción\n• Ficha de inscripción debidamente llena\n\nRequisitos adicionales pueden aplicar según la modalidad de ingreso. Para más información, visita nuestra oficina de admisión o llama al (042) 523991.',
                    keywords: ['requisitos', 'documentos', 'necesito', 'postular', 'inscripcion', 'papeles', 'tramite', 'que', 'presentar'],
                    relatedFaqs: ['adm-001', 'adm-005', 'adm-003']
                },
                {
                    id: 'adm-003',
                    question: '¿Cuánto cuesta la inscripción?',
                    answer: 'El costo de inscripción varía según la modalidad de ingreso elegida. Para obtener información exacta y actualizada sobre los costos, te recomendamos:\n\n• Llamar al (+51) 042 523991\n• Escribir a: admision@unsm.edu.pe\n• Visitar nuestra oficina en Jr. Amorarca N° 315, Morales\n\nEstamos disponibles de lunes a viernes de 8:00 AM a 5:00 PM.',
                    keywords: ['costo', 'precio', 'cuanto', 'pagar', 'inscripcion', 'pago', 'dinero', 'monto', 'tarifa'],
                    relatedFaqs: ['adm-001', 'adm-002', 'adm-005']
                },
                {
                    id: 'adm-004',
                    question: '¿Cómo me inscribo en línea?',
                    answer: 'Para inscribirte en línea, sigue estos pasos:\n\n1. Ingresa a nuestra página web oficial: www.unsm.edu.pe\n2. Busca la sección "Admisión" o "Inscripción en línea"\n3. Completa el formulario de inscripción con tus datos personales\n4. Adjunta los documentos solicitados en formato digital (PDF o JPG)\n5. Realiza el pago del derecho de inscripción\n6. Guarda tu número de inscripción\n\nSi tienes problemas, contacta a soporte técnico: admision@unsm.edu.pe',
                    keywords: ['como', 'inscribo', 'inscribirse', 'online', 'linea', 'virtual', 'internet', 'web', 'pasos', 'proceso'],
                    relatedFaqs: ['adm-003', 'adm-002', 'adm-001']
                },
                {
                    id: 'adm-005',
                    question: '¿Qué modalidades de ingreso existen?',
                    answer: 'La UNSM ofrece varias modalidades de ingreso:\n\n• Examen Ordinario: Para todos los postulantes\n• Centro Pre Universitario (CPU): Ciclo preparatorio previo\n• Primera y Segunda Opción: Para estudiantes destacados\n• Deportistas Calificados: Con logros deportivos\n• Víctimas del Terrorismo: Con documentación oficial\n• Traslado Externo: Desde otras universidades\n• Graduados o Titulados: Con título previo\n\nCada modalidad tiene requisitos específicos. Consulta en admision@unsm.edu.pe',
                    keywords: ['modalidades', 'ingreso', 'formas', 'opciones', 'tipos', 'cpu', 'examen', 'traslado'],
                    relatedFaqs: ['adm-002', 'adm-006', 'adm-001']
                },
                {
                    id: 'adm-006',
                    question: '¿Cuántas vacantes hay por carrera?',
                    answer: 'El número de vacantes varía por carrera y modalidad de ingreso. Generalmente, cada programa académico ofrece entre 30 a 80 vacantes por ciclo de admisión.\n\nPara conocer el número exacto de vacantes para la carrera de tu interés, te recomendamos:\n\n• Revisar el prospecto de admisión en nuestra página web\n• Llamar a admisión: (042) 523991\n• Visitar la oficina de admisión\n\nLas vacantes se publican oficialmente antes de cada proceso de admisión.',
                    keywords: ['vacantes', 'cupo', 'plazas', 'cuantas', 'disponibles', 'carrera', 'cupos'],
                    relatedFaqs: ['adm-005', 'adm-007', 'adm-001']
                },
                {
                    id: 'adm-007',
                    question: '¿Qué es el CPU y cómo me inscribo?',
                    answer: 'El Centro Pre Universitario (CPU) es un programa de preparación académica que te permite prepararte para el examen de admisión de la UNSM. Al aprobar el CPU, obtienes ingreso directo a la carrera elegida.\n\nCaracterísticas:\n• Duración: 1 ciclo académico (aproximadamente 4 meses)\n• Clases presenciales con docentes especializados\n• Material de estudio incluido\n• Simulacros de examen\n\nPara inscribirte, visita la oficina del CPU en Jr. Amorarca N° 315 o llama al (042) 523991.',
                    keywords: ['cpu', 'centro', 'pre', 'universitario', 'preuniversitario', 'preparacion', 'academia'],
                    relatedFaqs: ['adm-005', 'adm-003', 'adm-004']
                },
                {
                    id: 'adm-008',
                    question: '¿Cuál es el cronograma del examen de admisión?',
                    answer: 'El cronograma del examen de admisión 2026-I es el siguiente:\n\n• Inscripciones: 15 enero - 15 febrero 2026\n• Examen de admisión: 23 febrero 2026\n• Publicación de resultados: 25 febrero 2026\n• Matrícula de ingresantes: 28 febrero - 5 marzo 2026\n\nNota: Las fechas pueden estar sujetas a cambios. Verifica siempre en nuestra página web oficial o comunícate con admisión al (042) 523991.',
                    keywords: ['cronograma', 'fechas', 'examen', 'calendario', 'cuando', 'horario', 'resultados'],
                    relatedFaqs: ['adm-001', 'adm-009', 'adm-004']
                },
                {
                    id: 'adm-009',
                    question: '¿Puedo postular a dos carreras a la vez?',
                    answer: 'No, cada postulante solo puede inscribirse a UNA carrera profesional por proceso de admisión. Debes elegir cuidadosamente la carrera que deseas estudiar al momento de tu inscripción.\n\nSi no ingresas en tu primera opción, puedes volver a postular en el siguiente proceso de admisión a la misma carrera o a una diferente.\n\nTe recomendamos investigar bien sobre la carrera de tu interés antes de inscribirte.',
                    keywords: ['dos', 'carreras', 'varias', 'multiple', 'postular', 'inscribir', 'opciones'],
                    relatedFaqs: ['adm-005', 'adm-002', 'adm-001']
                },
                {
                    id: 'adm-010',
                    question: '¿Dónde rindo el examen de admisión?',
                    answer: 'El examen de admisión se rende en la Ciudad Universitaria de la UNSM, ubicada en Jr. Maynas N° 177, Morales, Tarapoto - San Martín.\n\nEl día del examen debes presentarte con:\n• DNI original\n• Carné de postulante\n• Lápiz 2B y borrador\n• Llegar 30 minutos antes\n\nLa ubicación exacta del aula se publicará en tu carné de postulante y en la página web 48 horas antes del examen.',
                    keywords: ['donde', 'ubicacion', 'rindo', 'examen', 'lugar', 'sede', 'aula'],
                    relatedFaqs: ['adm-008', 'serv-001', 'adm-001']
                }
            ]
        },

        orientacion: {
            id: 'orientacion',
            name: 'Orientación Vocacional',
            icon: '🎯',
            color: '#FF6B6B',
            description: 'Descubre qué carrera se adapta mejor a tus intereses y habilidades',
            faqs: [
                {
                    id: 'ori-001',
                    question: '¿Qué carrera debo estudiar?',
                    answer: '¡Excelente pregunta! Para recomendarte una carrera, me gustaría conocerte mejor.\n\n¿Cuáles son tus principales intereses o hobbies?\n\nPor ejemplo:\n• ¿Te gusta la naturaleza y las plantas?\n• ¿Te interesa la tecnología y programación?\n• ¿Disfrutas enseñar o ayudar a otros?\n• ¿Te apasiona la salud y medicina?\n• ¿Te gusta construir o diseñar?\n• ¿Prefieres los negocios y administración?\n\nCuéntame qué te apasiona y te ayudaré a encontrar la carrera perfecta para ti.',
                    keywords: ['carrera', 'estudiar', 'elegir', 'recomienda', 'recomendacion', 'cual', 'que', 'vocacion', 'profesion'],
                    relatedFaqs: ['ori-002', 'ori-003', 'ori-004']
                },
                {
                    id: 'ori-002',
                    question: 'Me gusta la naturaleza y el campo',
                    answer: '¡Perfecto! Si te apasiona la naturaleza, el campo y el medio ambiente, estas carreras son ideales para ti:\n\n🌱 **AGRONOMÍA**\n• Producción agrícola sostenible\n• Manejo de cultivos y suelos\n• Innovación en agricultura\n• Campo de trabajo: Empresas agrícolas, investigación, asesoría técnica\n\n🌿 **INGENIERÍA AMBIENTAL**\n• Conservación del medio ambiente\n• Gestión de recursos naturales\n• Proyectos de sostenibilidad\n• Campo de trabajo: Consultorías ambientales, ONGs, sector público\n\n¿Te gustaría conocer más sobre alguna de estas carreras?',
                    keywords: ['naturaleza', 'campo', 'plantas', 'agricultura', 'medio ambiente', 'ecologia', 'verde'],
                    relatedFaqs: ['ori-001', 'adm-005', 'adm-006']
                },
                {
                    id: 'ori-003',
                    question: 'Me gusta enseñar y trabajar con niños',
                    answer: '¡Qué vocación tan noble! Si disfrutas enseñar y trabajar con personas, estas carreras son para ti:\n\n👶 **EDUCACIÓN INICIAL**\n• Desarrollo integral de niños 0-5 años\n• Pedagogía para primera infancia\n• Estimulación temprana\n• Campo de trabajo: Jardines, cunas, centros de estimulación\n\n📚 **EDUCACIÓN PRIMARIA**\n• Enseñanza para niños 6-12 años\n• Metodologías educativas innovadoras\n• Desarrollo de habilidades básicas\n• Campo de trabajo: Colegios públicos y privados\n\n🎓 **EDUCACIÓN SECUNDARIA**\n• Especialización en áreas específicas\n• Educación para adolescentes\n• Desarrollo del pensamiento crítico\n• Campo de trabajo: Instituciones educativas de nivel secundario\n\n🧠 **PSICOLOGÍA** (¡Nueva carrera!)\n• Comprensión del comportamiento humano\n• Orientación y consejería\n• Salud mental y bienestar\n• Campo de trabajo: Clínicas, colegios, empresas, centros comunitarios\n\n¿Cuál de estas opciones te llama más la atención?',
                    keywords: ['enseñar', 'educar', 'ninos', 'profesor', 'maestro', 'docente', 'educacion', 'ayudar'],
                    relatedFaqs: ['ori-001', 'adm-005', 'adm-006']
                },
                {
                    id: 'ori-004',
                    question: 'Me interesa la tecnología y las computadoras',
                    answer: '¡Excelente elección! El mundo tecnológico tiene grandes oportunidades:\n\n💻 **INGENIERÍA DE SISTEMAS E INFORMÁTICA**\n• Desarrollo de software y aplicaciones\n• Programación y bases de datos\n• Ciberseguridad\n• Inteligencia artificial\n• Campo de trabajo: Empresas tech, startups, bancos, consultoras\n\n🏗️ **INGENIERÍA CIVIL** (con componente tecnológico)\n• Diseño asistido por computadora (CAD)\n• Gestión de proyectos con software especializado\n• Construcción inteligente\n• Campo de trabajo: Constructoras, consultoras, sector público\n\nLa carrera de Sistemas e Informática es perfecta si te gusta programar, crear aplicaciones y estar al día con la tecnología.\n\n¿Te gustaría más información sobre alguna de estas carreras?',
                    keywords: ['tecnologia', 'computadora', 'programacion', 'sistemas', 'informatica', 'software', 'apps'],
                    relatedFaqs: ['ori-001', 'adm-005', 'adm-006']
                },
                {
                    id: 'ori-005',
                    question: 'Me gusta la salud y ayudar a las personas',
                    answer: 'Una vocación de servicio admirable. Si te apasiona la salud y el bienestar, considera:\n\n⚕️ **MEDICINA HUMANA**\n• Diagnóstico y tratamiento de enfermedades\n• Atención médica integral\n• Investigación clínica\n• Campo de trabajo: Hospitales, clínicas, consultorios privados\n\n👶 **OBSTETRICIA**\n• Salud materno-infantil\n• Atención del embarazo y parto\n• Salud reproductiva\n• Campo de trabajo: Hospitales, centros de salud, consultorios\n\n🩺 **ENFERMERÍA**\n• Cuidado integral del paciente\n• Prevención y promoción de la salud\n• Trabajo en equipo multidisciplinario\n• Campo de trabajo: Hospitales, clínicas, atención domiciliaria\n\n🐾 **MEDICINA VETERINARIA**\n• Salud y bienestar animal\n• Clínica de animales mayores y menores\n• Salud pública veterinaria\n• Campo de trabajo: Clínicas veterinarias, granjas, investigación\n\n¿Qué área de la salud te interesa más?',
                    keywords: ['salud', 'medicina', 'doctor', 'enfermera', 'ayudar', 'curar', 'hospital', 'pacientes'],
                    relatedFaqs: ['ori-001', 'adm-005', 'adm-006']
                },
                {
                    id: 'ori-006',
                    question: 'Me gustan los negocios y emprender',
                    answer: '¡Espíritu emprendedor! Si te atraen los negocios y la gestión, estas carreras son ideales:\n\n💼 **ADMINISTRACIÓN**\n• Gestión empresarial\n• Recursos humanos\n• Marketing y ventas\n• Emprendimiento\n• Campo de trabajo: Empresas privadas, públicas, emprendimiento propio\n\n📊 **CONTABILIDAD**\n• Gestión financiera\n• Auditoría\n• Tributación\n• Análisis de costos\n• Campo de trabajo: Empresas, estudios contables, sector público\n\n💰 **ECONOMÍA**\n• Análisis económico\n• Finanzas y mercados\n• Políticas económicas\n• Consultoría\n• Campo de trabajo: Bancos, consultoras, gobierno, ONGs\n\n🏨 **TURISMO**\n• Gestión hotelera y turística\n• Desarrollo de destinos\n• Eventos y gastronomía\n• Campo de trabajo: Hoteles, agencias, restaurantes, eventos\n\n¿Cuál área de negocios te llama más la atención?',
                    keywords: ['negocios', 'empresa', 'emprender', 'administracion', 'economia', 'dinero', 'gerencia'],
                    relatedFaqs: ['ori-001', 'adm-005', 'adm-006']
                },
                {
                    id: 'ori-007',
                    question: 'Me gusta construir y diseñar',
                    answer: 'Si te fascina diseñar, construir y crear espacios, estas carreras son para ti:\n\n🏗️ **INGENIERÍA CIVIL**\n• Diseño de infraestructuras\n• Construcción de edificios y puentes\n• Gestión de proyectos\n• Carreteras y obras hidráulicas\n• Campo de trabajo: Constructoras, municipalidades, proyectos privados\n\n🏛️ **ARQUITECTURA**\n• Diseño de edificaciones\n• Planificación urbana\n• Creatividad y funcionalidad\n• Proyectos sostenibles\n• Campo de trabajo: Estudios de arquitectura, inmobiliarias, sector público\n\nAmbas carreras requieren creatividad, habilidad para las matemáticas y pensamiento espacial.\n\n¿Te identificas más con el diseño arquitectónico o la construcción?',
                    keywords: ['construir', 'diseñar', 'arquitectura', 'edificios', 'obras', 'planos', 'crear'],
                    relatedFaqs: ['ori-001', 'adm-005', 'adm-006']
                },
                {
                    id: 'ori-008',
                    question: 'Me interesa la justicia y las leyes',
                    answer: 'Una carrera que defiende la justicia y el orden social:\n\n⚖️ **DERECHO Y CIENCIAS POLÍTICAS**\n• Conocimiento del sistema jurídico\n• Defensa de derechos y justicia\n• Asesoría legal\n• Litigación y representación\n• Ciencias políticas y gobierno\n• Campo de trabajo: Estudios jurídicos, juzgados, empresas, sector público, política\n\nEs ideal si te gusta:\n• Argumentar y debatir\n• Leer e investigar\n• Defender causas justas\n• Resolver conflictos\n• Entender las leyes\n\n¿Te gustaría más información sobre esta carrera?',
                    keywords: ['derecho', 'leyes', 'justicia', 'abogado', 'legal', 'juez', 'politica'],
                    relatedFaqs: ['ori-001', 'adm-005', 'adm-006']
                },
                {
                    id: 'ori-009',
                    question: '¿Qué carreras ofrece la UNSM?',
                    answer: 'La UNSM ofrece una amplia variedad de carreras profesionales:\n\n🌱 **Ciencias Agrarias:**\n• Agronomía\n\n👨‍🏫 **Educación y Humanidades:**\n• Educación Inicial\n• Educación Primaria\n• Educación Secundaria\n• Idiomas\n• Psicología (¡Nueva!)\n\n🏥 **Ciencias de la Salud:**\n• Obstetricia\n• Enfermería\n• Medicina Humana\n\n🐾 **Medicina Veterinaria:**\n• Medicina Veterinaria\n\n💻 **Ingeniería de Sistemas e Informática:**\n• Ing. de Sistemas e Informática\n\n🏗️ **Ingeniería Civil y Arquitectura:**\n• Arquitectura\n• Ingeniería Civil\n\n🏭 **Ingeniería Agroindustrial:**\n• Ingeniería Agroindustrial\n\n🌿 **Ecología:**\n• Ingeniería Ambiental\n• Ingeniería Sanitaria\n\n⚖️ **Derecho y Ciencias Políticas:**\n• Derecho\n\n💼 **Ciencias Económicas:**\n• Administración\n• Contabilidad\n• Economía\n• Turismo\n\n¿Sobre cuál te gustaría saber más?',
                    keywords: ['carreras', 'cuales', 'ofrece', 'hay', 'disponibles', 'lista', 'que', 'puedo', 'estudiar'],
                    relatedFaqs: ['ori-001', 'adm-005', 'adm-006']
                }
            ]
        },

        servicios: {
            id: 'servicios',
            name: 'Servicios Administrativos',
            icon: '🏛️',
            color: '#2a7a35',
            description: 'Trámites, certificados, biblioteca, pagos y servicios universitarios',
            faqs: [
                {
                    id: 'serv-001',
                    question: '¿Dónde está ubicada la universidad?',
                    answer: 'La Universidad Nacional de San Martín tiene su sede principal en:\n\n📍 Jr. Maynas N° 177, Morales\nTarapoto - San Martín - Perú\n\nTambién contamos con sedes en:\n• Rioja\n• Moyobamba\n• Lamas\n• La Banda de Shilcayo\n\nPuedes ver nuestra ubicación exacta en Google Maps o visitarnos de lunes a viernes de 8:00 AM a 5:00 PM.',
                    keywords: ['ubicacion', 'direccion', 'donde', 'queda', 'esta', 'como', 'llegar', 'lugar', 'sede'],
                    relatedFaqs: ['serv-002', 'serv-003', 'serv-004']
                },
                {
                    id: 'serv-002',
                    question: '¿Cuál es el horario de atención?',
                    answer: 'Nuestro horario de atención es:\n\n🕐 Lunes a Viernes: 8:00 AM - 5:00 PM\n🕐 Sábados: Solo para trámites específicos (consultar previamente)\n\nDurante vacaciones o fechas especiales, el horario puede variar. Te recomendamos verificar en nuestra página web o llamar al (+51) 042 48 0159.\n\nPara emergencias académicas, puedes escribirnos a informes@unsm.edu.pe en cualquier momento.',
                    keywords: ['horario', 'atencion', 'hora', 'abierto', 'cuando', 'atender', 'abre', 'cierra'],
                    relatedFaqs: ['serv-001', 'serv-003', 'serv-005']
                },
                {
                    id: 'serv-003',
                    question: '¿Cómo puedo contactar a la universidad?',
                    answer: 'Puedes contactarnos a través de:\n\n📞 Teléfono: (+51) 042 48 0159\n📧 Email: informes@unsm.edu.pe\n📍 Dirección: Jr. Maynas N° 177, Morales - Tarapoto\n\nRedes sociales:\n• Facebook: @UNSMoficial\n• Instagram: @unsmoficial\n• Twitter: @unsmperu\n\nTambién puedes usar nuestro formulario de contacto en la página web o visitar nuestras oficinas de lunes a viernes de 8:00 AM a 5:00 PM.',
                    keywords: ['contacto', 'telefono', 'email', 'correo', 'comunicar', 'llamar', 'escribir', 'contactar'],
                    relatedFaqs: ['serv-001', 'serv-002', 'serv-004']
                },
                {
                    id: 'serv-004',
                    question: '¿Cómo solicito un certificado de estudios?',
                    answer: 'Para solicitar un certificado de estudios, sigue estos pasos:\n\n1. Acércate a la Oficina de Secretaría General con tu DNI\n2. Llena el formato de solicitud\n3. Realiza el pago correspondiente en caja o banco\n4. Presenta el voucher de pago\n5. Recoge tu certificado en 3-5 días hábiles\n\nRequisitos:\n• Estar al día en pagos\n• DNI original y copia\n• Recibo de pago\n\nPara más información: secretariageneral@unsm.edu.pe',
                    keywords: ['certificado', 'estudios', 'tramite', 'documento', 'constancia', 'solicitar', 'como'],
                    relatedFaqs: ['serv-005', 'serv-008', 'serv-002']
                },
                {
                    id: 'serv-005',
                    question: '¿Dónde puedo realizar pagos?',
                    answer: 'Puedes realizar tus pagos (matrícula, pensiones, certificados, etc.) en:\n\n🏦 Caja de la UNSM:\nJr. Maynas N° 177, Morales\nHorario: Lunes a Viernes, 8:00 AM - 3:00 PM\n\n🏦 Banco autorizado:\nBanco de la Nación (con código de estudiante)\n\n💻 Pago en línea:\nA través del sistema SIGAU (próximamente)\n\nImportante: Guarda siempre tu voucher de pago como comprobante.',
                    keywords: ['pago', 'pagos', 'pagar', 'donde', 'matricula', 'pension', 'caja', 'banco'],
                    relatedFaqs: ['serv-006', 'serv-004', 'serv-002']
                },
                {
                    id: 'serv-006',
                    question: '¿Cómo accedo a la biblioteca virtual?',
                    answer: 'Para acceder a la Biblioteca Virtual de la UNSM:\n\n1. Ingresa a www.unsm.edu.pe\n2. Busca la sección "Biblioteca Virtual"\n3. Inicia sesión con tu código de estudiante y contraseña\n4. Explora los recursos digitales disponibles\n\nRecursos disponibles:\n• Libros electrónicos\n• Revistas científicas\n• Bases de datos académicas\n• Tesis digitales\n• Repositorio institucional\n\nSoporte: biblioteca@unsm.edu.pe',
                    keywords: ['biblioteca', 'virtual', 'acceso', 'libros', 'digital', 'como', 'entrar', 'online'],
                    relatedFaqs: ['serv-007', 'serv-006', 'serv-002']
                },
                {
                    id: 'serv-007',
                    question: '¿Qué es SIGAU y cómo ingreso?',
                    answer: 'SIGAU es el Sistema Integrado de Gestión Académica Universitaria. A través de este sistema puedes:\n\n• Consultar tus notas\n• Ver tu horario de clases\n• Matricularte en cursos\n• Revisar tu historial académico\n• Realizar trámites en línea\n\nPara ingresar:\n1. Visita: sigau.unsm.edu.pe\n2. Usuario: Tu código de estudiante\n3. Contraseña: La que recibiste al matricularte\n\n¿Olvidaste tu contraseña? Contacta a soporte: sistemas@unsm.edu.pe',
                    keywords: ['sigau', 'sistema', 'ingresar', 'acceso', 'notas', 'matricula', 'plataforma', 'virtual'],
                    relatedFaqs: ['serv-006', 'serv-008', 'serv-002']
                },
                {
                    id: 'serv-008',
                    question: '¿Dónde tramito mi carnet universitario?',
                    answer: 'Para tramitar tu carnet universitario:\n\n📍 Lugar: Oficina de Bienestar Universitario\nJr. Maynas N° 177, Morales (dentro del campus)\n\nRequisitos:\n• Foto tamaño carnet fondo blanco\n• Copia de DNI\n• Recibo de matrícula vigente\n• Pago por derecho de carnet\n\nTiempo de entrega: 5-7 días hábiles\n\nHorario de atención: Lunes a Viernes, 8:00 AM - 2:00 PM\n\nMás info: bienestar@unsm.edu.pe',
                    keywords: ['carnet', 'universitario', 'tarjeta', 'tramite', 'donde', 'como', 'sacar'],
                    relatedFaqs: ['serv-004', 'serv-005', 'serv-009']
                },
                {
                    id: 'serv-009',
                    question: '¿Cómo solicito una constancia de matrícula?',
                    answer: 'Para solicitar una constancia de matrícula:\n\n1. Ingresa al sistema SIGAU con tu usuario\n2. Ve a la sección "Trámites"\n3. Selecciona "Constancia de Matrícula"\n4. Descarga el documento en PDF (es gratuito)\n\nAlternativamente:\n• Acude a Secretaría Académica de tu Facultad\n• Presenta tu DNI\n• Solicita la constancia impresa (puede tener costo)\n\nLa constancia virtual del SIGAU tiene la misma validez oficial.',
                    keywords: ['constancia', 'matricula', 'certificado', 'documento', 'solicitar', 'como'],
                    relatedFaqs: ['serv-007', 'serv-004', 'serv-002']
                },
                {
                    id: 'serv-010',
                    question: '¿Qué servicios ofrece Bienestar Universitario?',
                    answer: 'La Oficina de Bienestar Universitario ofrece:\n\n• 🏥 Tópico médico y primeros auxilios\n• 🧠 Atención psicológica gratuita\n• 💰 Becas y apoyo económico\n• 🏀 Programas deportivos y recreativos\n• 🎨 Talleres culturales y artísticos\n• 🍽️ Comedor universitario (precios subsidiados)\n• 📚 Apoyo académico y tutorías\n\nHorario: Lunes a Viernes, 8:00 AM - 5:00 PM\nUbicación: Campus principal\n\nContacto: bienestar@unsm.edu.pe',
                    keywords: ['bienestar', 'servicios', 'comedor', 'salud', 'psicologia', 'deporte', 'beca'],
                    relatedFaqs: ['serv-008', 'serv-002', 'serv-001']
                },
                {
                    id: 'serv-011',
                    question: '¿Cómo contacto con mi facultad?',
                    answer: 'Cada facultad tiene su propia oficina administrativa. Para contactar a tu facultad:\n\n1. Identifica tu facultad\n2. Busca en el directorio de la página web\n3. Llama o visita durante horario de atención\n\nTeléfono central: (+51) 042 48 0159\nPide que te transfieran a tu facultad específica\n\nO visita directamente:\n• Ubicación: Campus principal, Jr. Maynas N° 177\n• Horario: Lunes a Viernes, 8:00 AM - 5:00 PM\n\nCada facultad tiene correo electrónico propio listado en nuestra web.',
                    keywords: ['facultad', 'contactar', 'oficina', 'decanato', 'escuela', 'carrera'],
                    relatedFaqs: ['serv-001', 'serv-003', 'serv-002']
                },
                {
                    id: 'serv-012',
                    question: '¿Cómo accedo al Campus Virtual?',
                    answer: 'El Campus Virtual es la plataforma de educación en línea donde encontrarás tus cursos, materiales y actividades académicas.\n\nPara acceder:\n1. Visita: campusvirtual.unsm.edu.pe\n2. Usuario: Tu código de estudiante\n3. Contraseña: La que te proporcionó tu facultad\n\nEn el Campus Virtual puedes:\n• Ver tus cursos matriculados\n• Descargar materiales de clase\n• Entregar tareas y trabajos\n• Participar en foros\n• Ver anuncios de tus docentes\n• Realizar exámenes en línea\n\n¿Problemas de acceso? Contacta a soporte: campusvirtual@unsm.edu.pe',
                    keywords: ['campus', 'virtual', 'plataforma', 'moodle', 'cursos', 'online', 'clases', 'acceso', 'aula'],
                    relatedFaqs: ['serv-006', 'serv-007', 'serv-002']
                }
            ]
        }
    },

    // ============================================
    // ACCIONES RÁPIDAS POR PÁGINA Y ROL
    // ============================================
    quickActions: {
        // Acciones por página (sin rol seleccionado)
        default: [
            { text: '¿Qué carrera estudiar?', category: 'orientacion', faqId: 'ori-001' },
            { text: 'Carreras disponibles', category: 'orientacion', faqId: 'ori-009' },
            { text: 'Fechas de admisión', category: 'admision', faqId: 'adm-001' }
        ],
        admision: [
            { text: '¿Cuánto cuesta?', category: 'admision', faqId: 'adm-003' },
            { text: 'Modalidades de ingreso', category: 'admision', faqId: 'adm-005' },
            { text: '¿Cómo me inscribo?', category: 'admision', faqId: 'adm-004' }
        ],
        contacto: [
            { text: 'Horario de atención', category: 'servicios', faqId: 'serv-002' },
            { text: 'Dirección exacta', category: 'servicios', faqId: 'serv-001' },
            { text: 'Teléfonos', category: 'servicios', faqId: 'serv-003' }
        ],

        // Acciones por rol
        estudiante: [
            { text: 'Campus Virtual', category: 'servicios', faqId: 'serv-012' },
            { text: 'Biblioteca virtual', category: 'servicios', faqId: 'serv-006' },
            { text: 'Bienestar universitario', category: 'servicios', faqId: 'serv-010' }
        ],
        docente: [
            { text: 'Acceso a SIGAU Docente', category: 'servicios', faqId: 'serv-007' },
            { text: 'Biblioteca virtual', category: 'servicios', faqId: 'serv-006' },
            { text: 'Contacto con facultad', category: 'servicios', faqId: 'serv-011' }
        ],
        administrativo: [
            { text: 'Sistema de gestión', category: 'servicios', faqId: 'serv-007' },
            { text: 'Horarios de atención', category: 'servicios', faqId: 'serv-002' },
            { text: 'Ubicación de oficinas', category: 'servicios', faqId: 'serv-001' }
        ],
        visitante: [
            { text: '¿Qué carrera debo estudiar?', category: 'orientacion', faqId: 'ori-001' },
            { text: '¿Cuándo puedo postular?', category: 'admision', faqId: 'adm-001' },
            { text: '¿Cuánto cuesta la admisión?', category: 'admision', faqId: 'adm-003' }
        ]
    },

    // ============================================
    // MENSAJES DE BIENVENIDA POR PÁGINA
    // ============================================
    welcomeMessages: {
        default: '¡Hola! Soy el asistente virtual de la UNSM 👋\n\nEstoy aquí para ayudarte con:\n• Orientación vocacional - ¿No sabes qué estudiar?\n• Información sobre admisión e inscripción\n• Servicios administrativos y trámites\n\n¿En qué puedo ayudarte hoy?',

        admision: '¡Hola! Estás en la página de Admisión 📚\n\nPuedo ayudarte con:\n• Requisitos y documentos\n• Fechas y cronogramas\n• Costos y modalidades de ingreso\n• Proceso de inscripción\n\n¿Qué información necesitas?',

        contacto: '¡Hola! ¿Necesitas contactarnos? 📞\n\nPuedo darte información sobre:\n• Horarios de atención\n• Ubicación y direcciones\n• Teléfonos y correos\n• Cómo llegar a la universidad\n\n¿En qué puedo asistirte?'
    },

    // ============================================
    // MENSAJES FALLBACK
    // ============================================
    fallback: {
        noMatch: 'Lo siento, no encontré una respuesta exacta a tu pregunta. 😔\n\nPero puedo ayudarte de otras formas:',

        suggestions: [
            '¿Cuándo inicia el proceso de admisión?',
            '¿Cuáles son los requisitos para postular?',
            '¿Dónde está ubicada la universidad?'
        ],

        contactInfo: {
            email: 'informes@unsm.edu.pe',
            phone: '(+51) 042 48 0159',
            formUrl: '/contacto/indexContac.php',
            formText: 'Hablar con un asesor'
        }
    }
};

// Exportar para uso global
if (typeof window !== 'undefined') {
    window.CHATBOT_DATA = CHATBOT_DATA;
}
