<?php
// Cargar WordPress
require_once(__DIR__ . '/wordpress/wp-load.php');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Universidad Nacional de San Martín - UNSM en Tarapoto, Perú. 11 facultades con programas acreditados, admisión 2025, posgrado e investigación de excelencia en la Amazonía.">
    <meta name="keywords" content="UNSM, Universidad San Martín, educación superior Tarapoto, universidad Perú, admisión universidad, facultades UNSM, posgrado Tarapoto">
    <meta name="author" content="Universidad Nacional de San Martín">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#359444">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://www.unsm.edu.pe/">
    <meta property="og:title" content="Universidad Nacional de San Martín - UNSM | Excelencia Académica en la Amazonía">
    <meta property="og:description" content="Institución de educación superior con 11 facultades, programas acreditados y formación integral en Tarapoto, San Martín, Perú">
    <meta property="og:image" content="https://www.unsm.edu.pe/imagenes/logo UNSM.png">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://www.unsm.edu.pe/">
    <meta property="twitter:title" content="Universidad Nacional de San Martín - UNSM">
    <meta property="twitter:description" content="Formación profesional de excelencia en la Amazonía peruana">
    <meta property="twitter:image" content="https://www.unsm.edu.pe/imagenes/logo UNSM.png">
    
    <title>Universidad Nacional de San Martín - UNSM | Admisión 2025</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="imagenes/escudo unsm.png" sizes="48x48">
    <link rel="apple-touch-icon" href="imagenes/escudo unsm.png">
    
    <!-- Preload critical resources -->
    <link rel="preload" href="css/style.css" as="style">
    <link rel="preload" href="js/script.js" as="script">
    
    <!-- Stylesheet -->
    <link rel="stylesheet" href="css/style.css">
    
    <!-- Preconnect to external domains -->
    <link rel="preconnect" href="https://www.facebook.com">
    <link rel="preconnect" href="https://www.instagram.com">
    
    <!-- Schema.org markup para Google -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "EducationalOrganization",
      "name": "Universidad Nacional de San Martín",
      "alternateName": "UNSM",
      "url": "https://www.unsm.edu.pe",
      "logo": "https://www.unsm.edu.pe/imagenes/logo UNSM.png",
      "description": "Universidad pública en Tarapoto con 11 facultades y programas acreditados de pregrado y posgrado",
      "address": {
        "@type": "PostalAddress",
        "streetAddress": "Jr. Maynas N° 177 - Mo rales",
        "addressLocality": "Tarapoto",
        "addressRegion": "San Martín",
        "postalCode": "22201",
        "addressCountry": "PE"
      },
      "telephone": "+51-42-480159",
      "email": "informes@unsm.edu.pe",
      "sameAs": [
        "https://www.facebook.com/unsmperu",
        "https://www.instagram.com/unsmperu",
        "https://youtube.com/@unsmperu",
        "https://x.com/unsmperu",
        "https://www.tiktok.com/@campus.unsm"
      ],
      "foundingDate": "1979",
      "areaServed": {
        "@type": "Place",
        "name": "San Martín, Perú"
      }
    }
    </script>
</head>
<body>
    <!-- Skip to main content for accessibility -->
    <a href="#main-content" class="skip-to-content">Saltar al contenido principal</a>

    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en Facebook" aria-label="Página oficial de Facebook de la UNSM">
                    <img src="imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Síguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Síguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="imagenes/logo telefono.png" alt="Teléfono" class="contact-icon" width="18" height="18"> 
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18"> 
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="/" aria-label="Ir a la página principal de UNSM">
                    <img src="imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martín" width="auto" height="70">
                </a>
            </div>
            
            <!-- Botón Hamburguesa para móvil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menú de navegación" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>
            
            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">
                
                <!-- Logo en menú móvil -->
                <div class="mobile-nav-logo">
                    <img src="imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menú Nosotros">
                            <li><a href="nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="nosotros/mision/indexMision.php">Nuestra Misión y Visión</a></li>
                            <li><a href="nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="nosotros/calendarioAcade/indexCale.php">Calendario Acad&eacute;mico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Académico</a></li>
                                <li><a href="oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigación</a></li>
                                <li><a href="oficinas/secretaria general/indexSecreGene.php">Secretaría General</a></li>
                                <li><a href="oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicación e Imagen Institucional</a></li>
                                <li><a href="oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperación y Relaciones Internacionales</a></li>
                                <li><a href="oficinas/Organo de Control Institucional/indexOrgaConIns.php">Órgano de Control Institucional</a></li>
                                <li><a href="oficinas/Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="oficinas/Asesoria Juridica/indexAseJuri.php">Asesoría Jurídica</a></li>
                                <li><a href="oficinas/Grados y Titulos/indexGrados.php">Grados y Títulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Académicas</li>
                                <li><a href="oficinas/Academicos/OFICINA DE ADMISION/indexOfiAdmin.php">Oficina de Admisión</a></li>
                                <li><a href="oficinas/Academicos/ASUNTOS ACADEMICOS/indexAsunAca.php">Asuntos Académicos</a></li>
                                <li><a href="oficinas/Academicos/Seguimiento al Egresado e Insercion Laboral/indexSegui.php">Seguimiento al Egresado e Inserción Laboral</a></li>
                                <li><a href="oficinas/Academicos/TECNOLOGIAS DE LA INFORMACION/indexOTI.php">Tecnologías de la Información</a></li>
                                <li><a href="oficinas/Academicos/INCUBADORA DE EMPRESAS/indexIncu.php">Incubadora de Empresas</a></li>
                                <li><a href="oficinas/Academicos/FONDO EDITORIAL/indexFondo.php">Fondo Editorial</a></li>
                                <li><a href="oficinas/Academicos/COMITE ELECTORAL UNIVERSITARIO/indexComite.php">Comité Electoral Universitario</a></li>
                                <li><a href="oficinas/Academicos/INNOVACION Y TRANSFERENCIA TECNOLOGICA/indexInno.php">Innovación y Transferencia Tecnológica</a></li>
                                <li><a href="oficinas/Academicos/PRODUCCION DE BIENES Y SERVICIOS/indexProdu.php">Producción de Bienes y Servicios</a></li>
                                <li><a href="oficinas/Academicos/Responsabilidad Social Universitaria/indexRespon.php">Responsabilidad Social Universitaria</a></li>
                                <li><a href="oficinas/Academicos/SERVICIOS GENERALES/indexServiGe.php">Servicios Generales</a></li>
                                <li><a href="oficinas/Academicos/BIENESTAR UNIVERSITARIO/indexBienUni.php">Bienestar Universitario</a></li>
                                <li><a href="oficinas/Academicos/DEFENSORIA UNIVERSITARIA/indexDefUni.php">Defensoría Universitaria</a></li>
                                <li><a href="oficinas/Academicos/GESTION DE LA CALIDAD/indexGesCali.php">Gestión de la Calidad</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="admision/indexAdmin.php">ADMISIÓN</a></li>
                    <li><a href="#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menú Facultades">
                            <li class="has-submenu">
                                <a href="facultades/ciencias agrarias/indexAgra.php" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="facultades/ciencias agrarias/agronomia/indexAgro.php">Agronomía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="facultades/ciencias de la salud/indexSalud.php" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="facultades/ciencias de la salud/obstetricia/indexObst.php">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="facultades/medicina veterinaria/indexVet.php" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="facultades/medicina veterinaria/veterinaria/indexMedVet.php">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="facultades/Ingenieria Agroindustrial/indexIngAgroIndus.php" aria-haspopup="true" aria-expanded="false">Ingeniería Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Agroindustrial">
                                    <li><a href="facultades/Ingenieria Agroindustrial/agroindustrias/indexAgroIn.php">Ingeniería Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="facultades/Ingenieria civil y arquitectura/indexCivArq.php" aria-haspopup="true" aria-expanded="false">Ingeniería Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Civil y Arquitectura">
                                    <li><a href="facultades/Ingenieria civil y arquitectura/arquitectura/indexArqui.php">Arquitectura</a></li>
                                    <li><a href="facultades/Ingenieria civil y arquitectura/civil/indexCivil.php">Ingeniería Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="facultades/Ingenieria de sistemas e informatica/indexFisi.php" aria-haspopup="true" aria-expanded="false">Ingeniería de Sistemas e Informática</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería de Sistemas">
                                    <li><a href="facultades/Ingenieria de sistemas e informatica/episi/indexEpisi.php">Ingeniería de Sistemas e Informática</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="facultades/ecologia/indexEcolo.php" aria-haspopup="true" aria-expanded="false">Ecología</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecología">
                                    <li><a href="facultades/ecologia/ambiental/indexAmbi.php">Ingeniería Ambiental</a></li>
                                    <li><a href="facultades/ecologia/sanitaria/indexSani.php">Ingeniería Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="facultades/derecho y ciencias politicas/indexDerePoli.php" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Políticas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="facultades/derecho y ciencias politicas/derecho/indexDere.php">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="facultades/medicina humana/indexMed.php" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="facultades/medicina humana/medicina/indexMedicina.php">Medicina Humana</a></li>
                                    <li><a href="facultades/medicina humana/enfermeria/indexEnfer.php">Enfermería</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="facultades/ciencias economicas/indexCienEco.php" aria-haspopup="true" aria-expanded="false">Ciencias Económicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Económicas">
                                    <li><a href="facultades/ciencias economicas/administracion/indexAdminC.php">Administración</a></li>
                                    <li><a href="facultades/ciencias economicas/contabilidad/indexConta.php">Contabilidad</a></li>
                                    <li><a href="facultades/ciencias economicas/economia/indexEco.php">Economía</a></li>
                                    <li><a href="facultades/ciencias economicas/turismo/indexTuri.php">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="facultades/educacion y humanidades/indexEdu.php" aria-haspopup="true" aria-expanded="false">Educación y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educación">
                                    <li><a href="facultades/educacion y humanidades/educacion inicial/indexIni.php">Educación Inicial</a></li>
                                    <li><a href="facultades/educacion y humanidades/educacion primaria/indexPri.php">Educación Primaria</a></li>
                                    <li><a href="facultades/educacion y humanidades/educacion secundaria/indexSec.php">Educación Secundaria</a></li>
                                    <li><a href="facultades/educacion y humanidades/idiomas/indexIdio.php">Idiomas</a></li>
                                    <li>
                                        <a href="facultades/educacion y humanidades/psicologia/indexPsico.php">
                                            Psicología
                                            <span class="badge-nuevo">Nuevo</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Menú Transparencia">
                            <li><a href="#licenciamiento">Licenciamiento</a></li>
                            <li><a href="#institucional">Institucional Ley 30220</a></li>
                            <li><a href="#estandar">Estándar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>
                
                <!-- Logos gob.pe dentro del menú móvil -->
                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Perú">
                        <img src="imagenes/logo gobPe.png" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>
            
            <div class="gob-logos">
                <a href="https://www.transparencia.gob.pe/enlaces/pte_transparencia_enlaces.aspx?id_entidad=10409#.WbGP_pO0ndV" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Perú">
                    <img src="imagenes/logo gobPe.png" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Contenido Principal -->
    <main id="main-content">
        <!-- Carrusel Principal -->
        <section class="carousel" role="region" aria-label="Carrusel de imágenes destacadas" aria-roledescription="carousel">
            <div class="carousel-container" id="carouselContainer">
                <!-- Slide 1 -->
                <div class="carousel-slide" role="group" aria-roledescription="slide" aria-label="1 de 4">
                    <img src="imagenes/frotis unsm.jpg" alt="Vista panorámica del campus principal de la Universidad Nacional de San Martín" loading="eager" width="1920" height="600">
                    <div class="carousel-overlay">
                        <h1>Universidad Nacional de San Martín</h1>
                        <p>Excelencia Académica en la Amazonía Peruana</p>
                        <button class="carousel-button btn-inscribete" aria-label="Inscribirse en el proceso de admisión UNSM 2025">INSCRÍBETE AQUÍ</button>
                    </div>
                </div>
                
                <!-- Slide 2 -->
                <div class="carousel-slide" role="group" aria-roledescription="slide" aria-label="2 de 4">
                    <img src="imagenes/richard comedor.jpg" alt="Instalaciones modernas y servicios para estudiantes de la UNSM" loading="lazy" width="1920" height="600">
                    <div class="carousel-overlay">
                        <h2>Formación Integral</h2>
                        <p>Profesionales competitivos con valores</p>
                        <button class="carousel-button btn-inscribete" aria-label="Conocer más sobre la oferta académica">CONOCE MÁS</button>
                    </div>
                </div>
                
                <!-- Slide 3 -->
                <div class="carousel-slide" role="group" aria-roledescription="slide" aria-label="3 de 4">
                    <img src="imagenes/frotis unsm.jpg" alt="Proceso de admisión 2025 en la UNSM" loading="lazy" width="1920" height="600">
                    <div class="carousel-overlay">
                        <h2>Admisión 2025</h2>
                        <p>Inicia tu camino hacia la excelencia profesional</p>
                        <button class="carousel-button btn-inscribete" aria-label="Ver información completa de admisión">POSTULA AHORA</button>
                    </div>
                </div>
                
                <!-- Slide 4 -->
                <div class="carousel-slide" role="group" aria-roledescription="slide" aria-label="4 de 4">
                    <img src="imagenes/carreras.png" alt="11 facultades con carreras profesionales acreditadas en la UNSM" loading="lazy" width="1920" height="600">
                    <div class="carousel-overlay">
                        <h2>Carreras Profesionales</h2>
                        <p>11 facultades con programas acreditados</p>
                        <button class="carousel-button btn-inscribete" aria-label="Explorar todas las carreras disponibles">DESCUBRE MÁS</button>
                    </div>
                </div>
            </div>
            
            <!-- Controles del Carrusel -->
            <button class="carousel-prev" onclick="moveSlide(-1)" aria-label="Ir al slide anterior">
                <span aria-hidden="true">‹</span>
            </button>
            <button class="carousel-next" onclick="moveSlide(1)" aria-label="Ir al siguiente slide">
                <span aria-hidden="true">›</span>
            </button>
            
            <!-- Indicadores -->
            <div class="carousel-indicators" id="carouselControls" role="tablist" aria-label="Controles del carrusel"></div>
        </section>

        <!-- SECCIÓN DESTACADOS -->
        <section class="destacados-section" aria-labelledby="destacados-title">
            <div class="destacados-grid">
                <a href="#investigacion" class="destacado-card investigacion-card">
                    <img src="imagenes/cuadros/investigacion.jpg" alt="Investigación UNSM" loading="lazy">
                    <div class="destacado-overlay"></div>
                    <h3>INVESTIGACIÓN</h3>
                </a>
                <a href="#filiales" class="destacado-card filiales-card">
                    <img src="imagenes/cuadros/filial.jpg" alt="Filiales UNSM" loading="lazy">
                    <div class="destacado-overlay"></div>
                    <h3>FILIALES</h3>
                </a>
                <a href="#servicios-complementarios" class="destacado-card servicios-card">
                    <img src="imagenes/cuadros/servicios complementarios.jpg" alt="Servicios Complementarios UNSM" loading="lazy">
                    <div class="destacado-overlay"></div>
                    <h3>SERVICIOS COMPLEMENTARIOS</h3>
                </a>
                <a href="oficinas/Academicos/Seguimiento al Egresado e Insercion Laboral/indexSegui.php" class="destacado-card bolsa-card">
                    <img src="imagenes/cuadros/bolsa de trabajo.jpg" alt="Bolsa de Trabajo y Red de Egresados UNSM" loading="lazy">
                    <div class="destacado-overlay"></div>
                    <h3>BOLSA DE TRABAJO Y RED DE EGRESADOS</h3>
                </a>
            </div>
        </section>

        <!-- SECCIÓN OFERTA ACADÉMICA -->
        <section class="ofertas section-container" aria-labelledby="oferta-academica-title">
            <div class="content-wrapper">
                <h2 id="oferta-academica-title" class="section-title">Oferta Académica</h2>
                <div class="section-divider" aria-hidden="true"></div>
                
                <div class="cards-container-three">
                    <!-- Tarjeta 1: Programas de Pregrado -->
                    <article class="card">
                        <a href="#pregrado" aria-labelledby="pregrado-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"></path>
                                    <path d="M22 3h-6a4 4 0 0 0-4 4v14a3 3 0 0 1 3-3h7z"></path>
                                </svg>
                            </div>
                            <h3 id="pregrado-title" class="card-title">Programas de Pregrado</h3>
                            <p class="card-text">11 facultades con carreras innovadoras que forman profesionales de alto nivel, listos para liderar y transformar la región</p>
                        </a>
                    </article>

                    <!-- Tarjeta 2: Escuela de Posgrado -->
                    <article class="card">
                        <a href="#posgrado" aria-labelledby="posgrado-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                                    <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                                </svg>
                            </div>
                            <h3 id="posgrado-title" class="card-title">Escuela de Posgrado</h3>
                            <p class="card-text">Maestrías y doctorados para quienes desean especializarse y convertirse en líderes de investigación y gestión</p>
                        </a>
                    </article>

                    <!-- Tarjeta 3: Formación Continua -->
                    <article class="card">
                        <a href="#formacion-continua" aria-labelledby="formacion-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="9" cy="7" r="4"></circle>
                                    <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                                    <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                </svg>
                            </div>
                            <h3 id="formacion-title" class="card-title">Formación Continua</h3>
                            <p class="card-text">Programas de actualización profesional, certificaciones y capacitación especializada para el desarrollo continuo</p>
                        </a>
                    </article>
                </div>
            </div>
        </section>

        <!-- SECCIÓN ACADÉMICO -->
        <section class="academico section-container" aria-labelledby="academico-title">
            <div class="content-wrapper">
                <h2 id="academico-title" class="section-title">Académico</h2>
                <div class="section-divider" aria-hidden="true"></div>
                
                <div class="academic-carousel-wrapper">
                    <div class="cards-container-academic-six" id="academicCarouselContainer">
                        <!-- Tarjeta 1: CPU - UNSM -->
                        <article class="card academic-carousel-slide">
                            <a href="#cpu" aria-labelledby="cpu-title">
                                <div class="card-image">
                                    <img src="imagenes/academico/centro preuniversitario.png" alt="Centro Preuniversitario UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="9" cy="7" r="4"></circle>
                                        <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                                        <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                    </svg>
                                </div>
                                <h3 id="cpu-title" class="card-title">CPU - UNSM</h3>
                                <p class="card-text">El Centro Preuniversitario brinda preparación académica integral para el ingreso a la universidad</p>
                            </a>
                        </article>

                        <!-- Tarjeta 2: Centro de Idiomas -->
                        <article class="card academic-carousel-slide">
                            <a href="#centro-idiomas" aria-labelledby="idiomas-title">
                                <div class="card-image">
                                    <img src="imagenes/academico/centro de idiomas.png" alt="Centro de Idiomas UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M12 2a10 10 0 1 0 0 20 10 10 0 0 0 0-20z"></path>
                                        <path d="M2 12h20M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path>
                                    </svg>
                                </div>
                                <h3 id="idiomas-title" class="card-title">Centro de Idiomas</h3>
                                <p class="card-text">La UNSM te ofrece programas certificados de inglés, portugués, francés, italiano, quechua y más</p>
                            </a>
                        </article>

                        <!-- Tarjeta 3: Campus Virtual -->
                        <article class="card academic-carousel-slide">
                            <a href="#campus-virtual" aria-labelledby="campus-title">
                                <div class="card-image">
                                    <img src="imagenes/academico/CAMPUS VIRTUAL.png" alt="Campus Virtual UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                        <polyline points="9 22 9 12 15 12 15 22"></polyline>
                                    </svg>
                                </div>
                                <h3 id="campus-title" class="card-title">Campus Virtual</h3>
                                <p class="card-text">Plataforma Docente de la Universidad Nacional de San Martín para recursos y estudios online</p>
                            </a>
                        </article>

                        <!-- Tarjeta 4: Investigación y Desarrollo -->
                        <article class="card academic-carousel-slide">
                            <a href="#investigacion" aria-labelledby="investigacion-title">
                                <div class="card-image">
                                    <img src="imagenes/academico/escuela de posgrado.jpg" alt="Investigación y Desarrollo UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <circle cx="11" cy="11" r="8"></circle>
                                        <path d="m21 21-4.35-4.35"></path>
                                    </svg>
                                </div>
                                <h3 id="investigacion-title" class="card-title">Investigación y Desarrollo</h3>
                                <p class="card-text">La Oficina de Investigación Universitaria se encarga de proyectos de investigación regional</p>
                            </a>
                        </article>

                        <!-- Tarjeta 5: Escuela de Posgrado -->
                        <article class="card academic-carousel-slide">
                            <a href="#escuela-posgrado" aria-labelledby="escuela-posgrado-title">
                                <div class="card-image">
                                    <img src="imagenes/academico/escuela de posgrado.jpg" alt="Escuela de Posgrado UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                                        <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                                    </svg>
                                </div>
                                <h3 id="escuela-posgrado-title" class="card-title">Escuela de Posgrado</h3>
                                <p class="card-text">Nuestra Escuela de Posgrado ofrece programas de especialización y formación en investigación</p>
                            </a>
                        </article>

                        <!-- Tarjeta 6: CTI - UNSM -->
                        <article class="card academic-carousel-slide">
                            <a href="#cti-unsm" aria-labelledby="cti-title">
                                <div class="card-image">
                                    <img src="imagenes/academico/CTI.png" alt="Centro de Tecnologías de Información UNSM" loading="lazy">
                                </div>
                                <div class="card-icon" aria-hidden="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                                        <line x1="8" y1="21" x2="16" y2="21"></line>
                                        <line x1="12" y1="17" x2="12" y2="21"></line>
                                    </svg>
                                </div>
                                <h3 id="cti-title" class="card-title">CTI - UNSM</h3>
                                <p class="card-text">El Centro de Tecnologías de Información se encarga de brindar soporte tecnológico</p>
                            </a>
                        </article>
                    </div>

                    <!-- Controles del carrusel (solo móvil) -->
                    <button class="academic-carousel-prev" onclick="moveAcademicSlide(-1)" aria-label="Tarjetas académicas anteriores">
                        <span aria-hidden="true">‹</span>
                    </button>
                    <button class="academic-carousel-next" onclick="moveAcademicSlide(1)" aria-label="Siguientes tarjetas académicas">
                        <span aria-hidden="true">›</span>
                    </button>
                    
                    <!-- Indicadores (solo móvil) -->
                    <div class="academic-carousel-indicators" id="academicCarouselDots" role="tablist" aria-label="Indicadores de tarjetas académicas"></div>
                </div>
            </div>
        </section>

        <!-- SECCIÓN FACULTADES CON CARRUSEL INFINITO -->
        <section class="facultades section-container" aria-labelledby="facultades-title">
            <div class="content-wrapper">
                <h2 id="facultades-title" class="section-title">Nuestras Facultades</h2>
                <div class="section-divider" aria-hidden="true"></div>
                
                <div class="facultades-carousel-wrapper">
                    <div class="facultades-carousel-container" id="facultadesCarouselContainer" role="region" aria-label="Carrusel de facultades">
                        <!-- Los slides se generarán dinámicamente por JavaScript para incluir clones -->
                    </div>
                    
                    <button class="carousel-prev facultades-prev" onclick="moveFacultadesSlide(-1)" aria-label="Facultades anteriores">
                        <span aria-hidden="true">‹</span>
                    </button>
                    <button class="carousel-next facultades-next" onclick="moveFacultadesSlide(1)" aria-label="Siguientes facultades">
                        <span aria-hidden="true">›</span>
                    </button>
                    
                    <!-- Indicadores -->
                    <div class="carousel-indicators" id="facultadesDots" role="tablist" aria-label="Indicadores de facultades"></div>
                </div>
            </div>
        </section>

        <!-- SECCIÓN NOTICIAS WORDPRESS -->
        <section class="noticias section-container" aria-labelledby="noticias-title">
            <div class="content-wrapper">
                <h2 id="noticias-title" class="section-title">Últimas Noticias</h2>
                <div class="section-divider" aria-hidden="true"></div>

                <?php
                // Configurar consulta de WordPress para obtener las últimas 3 noticias
                $args = array(
                    'post_type'      => 'post',
                    'posts_per_page' => 3,
                    'orderby'        => 'date',
                    'order'          => 'DESC',
                    'post_status'    => 'publish'
                );

                $noticias_query = new WP_Query($args);

                if ($noticias_query->have_posts()) : ?>
                    <div class="cards-container">
                        <?php while ($noticias_query->have_posts()) : $noticias_query->the_post(); ?>
                            <article class="card">
                                <a href="<?php echo get_permalink(); ?>" aria-labelledby="noticia-<?php echo get_the_ID(); ?>">
                                    <div class="card-image">
                                        <?php if (has_post_thumbnail()) : ?>
                                            <?php the_post_thumbnail('medium', array('alt' => get_the_title())); ?>
                                        <?php else : ?>
                                            <img src="imagenes/cuadros/investigacion.jpg" alt="<?php echo esc_attr(get_the_title()); ?>" loading="lazy">
                                        <?php endif; ?>
                                        <div class="card-overlay-green">
                                            <?php
                                            $categories = get_the_category();
                                            if (!empty($categories)) {
                                                echo '<span class="news-category">' . esc_html(strtoupper($categories[0]->name)) . '</span>';
                                            }
                                            ?>
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <time class="news-meta" datetime="<?php echo get_the_date('c'); ?>">
                                            <span>📅 <?php echo get_the_date('d M Y'); ?></span>
                                        </time>
                                        <h3 id="noticia-<?php echo get_the_ID(); ?>" class="card-title">
                                            <?php the_title(); ?>
                                        </h3>
                                        <p class="card-text">
                                            <?php echo wp_trim_words(get_the_excerpt(), 15, '...'); ?>
                                        </p>
                                        <span class="card-button">Leer más</span>
                                    </div>
                                </a>
                            </article>
                        <?php endwhile; ?>
                    </div>
                <?php else : ?>
                    <div class="cards-container">
                        <p style="text-align: center; padding: 40px; color: #666;">No hay noticias disponibles en este momento.</p>
                    </div>
                <?php endif; ?>

                <?php wp_reset_postdata(); ?>

                <div class="noticias-btn-container" style="text-align: center; margin-top: 30px;">
                    <a href="Noticias/indexNoti.php" class="btn-mas-noticias">
                        + Noticias
                    </a>
                </div>
            </div>
        </section>

        <!-- SECCIÓN ADMINISTRATIVOS -->
        <section class="administrativos section-container" aria-labelledby="administrativos-title">
            <div class="content-wrapper">
                <h2 id="administrativos-title" class="section-title">Administrativos</h2>
                <div class="section-divider" aria-hidden="true"></div>
                
                <div class="cards-container-three">
                    <!-- Tarjeta 1: Sistema de Gestión Documentaria -->
                    <article class="card">
                        <a href="#gestion-documentaria" aria-labelledby="gestion-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                    <polyline points="14 2 14 8 20 8"></polyline>
                                    <line x1="16" y1="13" x2="8" y2="13"></line>
                                    <line x1="16" y1="17" x2="8" y2="17"></line>
                                    <polyline points="10 9 9 9 8 9"></polyline>
                                </svg>
                            </div>
                            <h3 id="gestion-title" class="card-title">Sistema de Gestión Documentaria</h3>
                            <p class="card-text">Trámite de expedientes y registro electrónico de documentos oficiales</p>
                        </a>
                    </article>

                    <!-- Tarjeta 2: Servicios -->
                    <article class="card">
                        <a href="#servicios" aria-labelledby="servicios-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                            </div>
                            <h3 id="servicios-title" class="card-title">Servicios</h3>
                            <p class="card-text">Atención personalizada in biblioteca, registro de títulos, y soporte técnico para estudiantes</p>
                        </a>
                    </article>

                    <!-- Tarjeta 3: Mesa de Ayuda -->
                    <article class="card">
                        <a href="#mesa-ayuda" aria-labelledby="ayuda-title">
                            <div class="card-icon" aria-hidden="true">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <circle cx="12" cy="12" r="10"></circle>
                                    <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path>
                                    <line x1="12" y1="17" x2="12.01" y2="17"></line>
                                </svg>
                            </div>
                            <h3 id="ayuda-title" class="card-title">Mesa de Ayuda</h3>
                            <p class="card-text">Atención rápida para consultas académicas, trámites administrativos, y soporte para plataforma virtual</p>
                        </a>
                    </article>
                </div>
            </div>
        </section>

        <!-- SECCIÓN ENLACES DE INTERÉS -->
        <section class="enlaces-interes" aria-labelledby="enlaces-title">
            <div class="content-wrapper">
                <h2 id="enlaces-title" class="section-title-enlaces">Enlaces de Interés</h2>
                <div class="section-divider-enlaces" aria-hidden="true"></div>
                
                <nav class="enlaces-grid-buttons" aria-label="Enlaces de interés y servicios">
                    <!-- COLUMNA 1 -->
                    <a href="#correo-institucional" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                            <polyline points="22,6 12,13 2,6"></polyline>
                        </svg>
                        <span>Correo Institucional</span>
                    </a>
                    
                    <a href="#biblioteca-central" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M4 19.5A2.5 2.5 0 0 1 6.5 17H20"></path>
                            <path d="M6.5 2H20v20H6.5A2.5 2.5 0 0 1 4 19.5v-15A2.5 2.5 0 0 1 6.5 2z"></path>
                        </svg>
                        <span>Biblioteca Central</span>
                    </a>
                    
                    <a href="oficinas/Academicos/Seguimiento al Egresado e Insercion Laboral/indexSegui.php" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                            <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                        </svg>
                        <span>Sistema de Egresados</span>
                    </a>
                    
                    <a href="#mesa-partes-digital" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                            <polyline points="14 2 14 8 20 8"></polyline>
                        </svg>
                        <span>Mesa de Partes Digital</span>
                    </a>
                    
                    <a href="#sigau-docente" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                            <circle cx="9" cy="7" r="4"></circle>
                        </svg>
                        <span>Sigau Docente</span>
                    </a>

                    <!-- COLUMNA 2 -->
                    <a href="#convocatoria-personal" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                            <circle cx="8.5" cy="7" r="4"></circle>
                            <line x1="20" y1="8" x2="20" y2="14"></line>
                            <line x1="23" y1="11" x2="17" y2="11"></line>
                        </svg>
                        <span>Convocatoria de Personal</span>
                    </a>
                    
                    <a href="#gestion-documental" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                            <polyline points="14 2 14 8 20 8"></polyline>
                        </svg>
                        <span>Gestión Documental (SGD)</span>
                    </a>
                    
                    <a href="#grados-titulos" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                            <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                        </svg>
                        <span>Grados y Títulos</span>
                    </a>
                    
                    <a href="#servicios-generales" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <circle cx="12" cy="12" r="3"></circle>
                            <path d="M12 1v6m0 6v6"></path>
                        </svg>
                        <span>Servicios</span>
                    </a>
                    
                    <a href="#sigau-matricula" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <circle cx="12" cy="12" r="10"></circle>
                            <polyline points="12 6 12 12 16 14"></polyline>
                        </svg>
                        <span>Sigau Matrícula</span>
                    </a>

                    <!-- COLUMNA 3 -->
                    <a href="#bienestar-universitario" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28"></path>
                        </svg>
                        <span>Bienestar Universitario</span>
                    </a>
                    
                    <a href="#cti" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                            <line x1="8" y1="21" x2="16" y2="21"></line>
                        </svg>
                        <span>CTI</span>
                    </a>
                    
                    <a href="#acreditacion" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                            <circle cx="12" cy="12" r="10"></circle>
                        </svg>
                        <span>Oficina de Acreditación</span>
                    </a>
                    
                    <a href="#sigau-intranet" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                            <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                        </svg>
                        <span>Sigau Intranet</span>
                    </a>
                    
                    <a href="#sigau-bienestar" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06"></path>
                        </svg>
                        <span>Sigau Bienestar</span>
                    </a>

                    <!-- COLUMNA 4 -->
                    <a href="#pagos-virtuales" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <line x1="12" y1="1" x2="12" y2="23"></line>
                            <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5"></path>
                        </svg>
                        <span>Pagos Virtuales</span>
                    </a>
                    
                    <a href="#repositorio-digital" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"></path>
                            <path d="M22 3h-6a4 4 0 0 0-4 4v14"></path>
                        </svg>
                        <span>Repositorio Digital</span>
                    </a>
                    
                    <a href="#museo-regional" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path>
                            <circle cx="12" cy="10" r="3"></circle>
                        </svg>
                        <span>Museo Regional</span>
                    </a>
                    
                    <a href="#sigau-tutoria" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M12 2L2 7l10 5 10-5-10-5z"></path>
                            <path d="M2 17l10 5 10-5"></path>
                        </svg>
                        <span>Sigau Tutoría</span>
                    </a>
                    
                    <a href="#aula-virtual" class="enlace-btn-green">
                        <svg class="enlace-btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
                            <path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"></path>
                            <line x1="10" y1="12" x2="14" y2="12"></line>
                        </svg>
                        <span>Aula Virtual</span>
                    </a>
                </nav>
            </div>
        </section>
    </main>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central Telefónica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>
            
            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="#admision">Admisión</a></li>
                    <li><a href="#facultades">Facultades</a></li>
                    <li><a href="#posgrado">Posgrado</a></li>
                    <li><a href="#investigacion">Investigación</a></li>
                </ul>
            </nav>
            
            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="#campus-virtual">Campus Virtual</a></li>
                    <li><a href="#repositorio">Repositorio Institucional</a></li>
                    <li><a href="#transparencia">Portal de Transparencia</a></li>
                    <li><a href="#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Martín - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>
        
        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <!-- Chatbot de Ayuda UNSM -->
    <?php include(__DIR__ . '/includes/chatbot-widget.php'); ?>

    <!-- Scripts -->
    <script src="js/script.js" defer></script>
    <script src="js/chatbot-data.js" defer></script>
    <script src="js/chatbot.js" defer></script>
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>
</body>
</html>