<!-- ============================================
     CHATBOT DE AYUDA UNSM
     Widget flotante de asistencia virtual
     ============================================ -->

<!-- Botón flotante del chatbot -->
<button
    class="chatbot__button"
    id="chatbotButton"
    aria-label="Abrir asistente virtual"
    aria-expanded="false"
    role="button"
    title="Asistente Virtual UNSM">
    <svg class="chatbot__icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
    </svg>
    <svg class="chatbot__icon chatbot__icon--close" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <line x1="18" y1="6" x2="6" y2="18"></line>
        <line x1="6" y1="6" x2="18" y2="18"></line>
    </svg>
</button>

<!-- Ventana del chatbot -->
<div
    class="chatbot__window"
    id="chatbotWindow"
    role="dialog"
    aria-label="Chat de ayuda UNSM"
    aria-hidden="true">

    <!-- Header del chatbot -->
    <div class="chatbot__header">
        <div class="chatbot__header-content">
            <div class="chatbot__logo">
                <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                </svg>
            </div>
            <div class="chatbot__header-text">
                <h2 class="chatbot__title">Asistente Virtual UNSM</h2>
                <p class="chatbot__subtitle">Estamos aquí para ayudarte</p>
            </div>
        </div>
        <button
            class="chatbot__close-btn"
            id="chatbotCloseBtn"
            aria-label="Cerrar chat"
            title="Cerrar">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <line x1="18" y1="6" x2="6" y2="18"></line>
                <line x1="6" y1="6" x2="18" y2="18"></line>
            </svg>
        </button>
    </div>

    <!-- Área de mensajes -->
    <div
        class="chatbot__messages"
        id="chatbotMessages"
        role="log"
        aria-live="polite"
        aria-atomic="false">
        <!-- Los mensajes se agregarán dinámicamente aquí -->
    </div>

    <!-- Indicador de escritura (typing) -->
    <div class="chatbot__typing" id="chatbotTyping" style="display: none;">
        <div class="chatbot__typing-dots">
            <span></span>
            <span></span>
            <span></span>
        </div>
        <p class="chatbot__typing-text">El asistente está escribiendo...</p>
    </div>

    <!-- Botones de acción rápida -->
    <div class="chatbot__quick-actions" id="chatbotQuickActions">
        <!-- Se generarán dinámicamente según la página -->
    </div>

    <!-- Área de input -->
    <div class="chatbot__input-area">
        <input
            type="text"
            class="chatbot__input"
            id="chatbotInput"
            placeholder="Escribe tu pregunta..."
            aria-label="Escribe tu pregunta"
            maxlength="500"
            autocomplete="off">
        <button
            class="chatbot__send-btn"
            id="chatbotSendBtn"
            aria-label="Enviar mensaje"
            title="Enviar">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <line x1="22" y1="2" x2="11" y2="13"></line>
                <polygon points="22 2 15 22 11 13 2 9 22 2"></polygon>
            </svg>
        </button>
    </div>

    <!-- Footer con info adicional -->
    <div class="chatbot__footer">
        <p class="chatbot__footer-text">
            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <circle cx="12" cy="12" r="10"></circle>
                <line x1="12" y1="16" x2="12" y2="12"></line>
                <line x1="12" y1="8" x2="12.01" y2="8"></line>
            </svg>
            Powered by UNSM
        </p>
    </div>
</div>

<!-- Estilos del chatbot -->
<link rel="stylesheet" href="<?php echo (strpos($_SERVER['REQUEST_URI'], '/admision/') !== false || strpos($_SERVER['REQUEST_URI'], '/contacto/') !== false) ? '../css/chatbot.css' : 'css/chatbot.css'; ?>">
