<?php
// Cargar WordPress
require_once(__DIR__ . '/../../../wordpress/wp-load.php');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Escuela Profesional de Ingeniería Ambiental - Facultad de Ecología - UNSM">
    <meta name="keywords" content="UNSM, Ingeniería Ambiental, Ecología, Medio Ambiente, Universidad San Martin">
    <meta name="author" content="Universidad Nacional de San Martin">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#4CAF50">

    <title>Escuela de Ingeniería Ambiental - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../../css/style.css">
    <!-- Stylesheet Facultad -->
    <link rel="stylesheet" href="../css/styleEcolo.css">
    <!-- Stylesheet Ingeniería Ambiental -->
    <link rel="stylesheet" href="css/styleAmbi.css?v=1.0">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en Facebook" aria-label="Página oficial de Facebook de la UNSM">
                    <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Síguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Síguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../../imagenes/logo telefono.png" alt="Teléfono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../../" aria-label="Ir a la página principal de UNSM">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martín" width="auto" height="70">
                </a>
            </div>

            <!-- Botón Hamburguesa para móvil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menú de navegación" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">
                <div class="mobile-nav-logo">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menú Nosotros">
                            <li><a href="../../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../../nosotros/mision/indexMision.php">Nuestra Misión y Visión</a></li>
                            <li><a href="../../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../../nosotros/calendarioAcade/indexCale.php">Calendario Académico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Académico</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../../admision/indexAdmin.php">ADMISIÓN</a></li>
                    <li><a href="../../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menú Facultades">
                            <li class="has-submenu">
                                <a href="../../ciencias agrarias/indexAgra.php" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../ciencias agrarias/agronomia/indexAgro.php">Agronomía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../indexEcolo.php" aria-haspopup="true" aria-expanded="false">Ecología</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecología">
                                    <li><a href="indexAmbi.php">Ingeniería Ambiental</a></li>
                                    <li><a href="../sanitaria/indexSani.php">Ingeniería Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../Ingenieria civil y arquitectura/indexCivArq.php" aria-haspopup="true" aria-expanded="false">Ingeniería Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Civil y Arquitectura">
                                    <li><a href="../../Ingenieria civil y arquitectura/arquitectura/indexArqui.php">Arquitectura</a></li>
                                    <li><a href="../../Ingenieria civil y arquitectura/civil/indexCivil.php">Ingeniería Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../Ingenieria de sistemas e informatica/indexFisi.php" aria-haspopup="true" aria-expanded="false">Ingeniería de Sistemas e Informática</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería de Sistemas">
                                    <li><a href="../../Ingenieria de sistemas e informatica/episi/indexEpisi.php">Ingeniería de Sistemas e Informática</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../medicina veterinaria/indexVet.php" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../../medicina veterinaria/veterinaria/indexMedVet.php">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../../#posgrado">POSGRADO</a></li>
                    <li><a href="../../../#transparencia">TRANSPARENCIA</a></li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Perú">
                        <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Perú">
                    <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Ingeniería Ambiental -->
    <section class="ambi-banner">
        <div class="banner-image">
            <img src="../imagenes/ambiental-banner.jpg" alt="Profesionales de ingeniería ambiental en campo">
        </div>
        <div class="banner-overlay"></div>
        <div class="banner-content-wrapper">
            <div class="banner-header">
                <div class="banner-logo">
                    <img src="../../../imagenes/Escudos de Facultades — UNSM/FECOL-UNSM-2021.png" alt="Logo Facultad de Ecología" width="80" height="80">
                </div>
                <div class="banner-title-section">
                    <h1>ESCUELA DE INGENIERÍA AMBIENTAL</h1>
                    <p class="banner-breadcrumb">Facultad de Ecología</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Sección Información con Tabs y Sidebar de Eventos -->
    <section class="info-section">
        <div class="info-container">
            <div class="tabs-wrapper">
                <div class="tabs-buttons">
                    <button class="tab-button active" data-tab="escuela">ESCUELA</button>
                    <button class="tab-button" data-tab="mision">MISIÓN</button>
                    <button class="tab-button" data-tab="vision">VISIÓN</button>
                </div>

                <div class="tabs-content">
                    <div class="tab-content active" id="escuela">
                        <p>La EPIS tiene 07 años de creación y la carrera profesional de Ingeniería Sanitaria se presenta como una fortaleza de Educación Superior Universitaria, para el área del saneamiento básico del Departamento de San Martín. Nuestros egresados vienen laborando en proyectos afines a su formación profesional, ya que existe un crecimiento de la demanda laboral debido a los proyectos dados por el Ministerio de Vivienda, Construcción y Saneamiento.</p>
                        <p>Promueve iniciativas humanísticas, científicas y tecnológicas que facilite la solución integral de la problemática ambiental local, regional, nacional e internacional; ampliando las posibilidades laborales de nuestros graduados.</p>
                    </div>
                    <div class="tab-content" id="mision">
                        <p>Formar ingenieros ambientales competentes con sólidos conocimientos científicos, tecnológicos y humanísticos, capaces de diseñar, implementar y gestionar soluciones ambientales sostenibles que contribuyan a la protección y conservación del medio ambiente en la región San Martín y el país.</p>
                    </div>
                    <div class="tab-content" id="vision">
                        <p>Ser una escuela profesional líder en la formación de ingenieros ambientales competitivos y comprometidos con el desarrollo sostenible, reconocida por su excelencia académica, investigación científica e innovación tecnológica al servicio de la conservación ambiental.</p>
                    </div>
                </div>
            </div>

            <!-- Sidebar de Próximos Eventos -->
            <aside class="eventos-sidebar">
                <h3>Próximos Eventos</h3>
                <p class="no-eventos">No hay nuevos eventos.</p>
                <div class="eventos-actions">
                    <button class="btn-add-evento">Añadir</button>
                    <a href="#" class="btn-calendario">Ver Calendario</a>
                </div>
            </aside>
        </div>
    </section>

    <!-- Sección Carrera Profesional -->
    <section class="carrera-section">
        <div class="carrera-container">
            <div class="carrera-header">
                <h2>CARRERA PROFESIONAL: INGENIERÍA AMBIENTAL</h2>
            </div>

            <div class="carrera-grid">
                <!-- Sidebar de navegación -->
                <nav class="carrera-sidebar">
                    <ul class="sidebar-nav">
                        <li><a href="#perfil" class="active" data-content="perfil">PERFIL PROFESIONAL <span class="nav-icon">👤</span></a></li>
                        <li><a href="#aptitudes" data-content="aptitudes">APTITUDES REQUERIDAS <span class="nav-icon">👍</span></a></li>
                        <li><a href="#campo" data-content="campo">CAMPO LABORAL <span class="nav-icon">💼</span></a></li>
                        <li><a href="#malla" data-content="malla">MALLA CURRICULAR <span class="nav-icon">📋</span></a></li>
                        <li><a href="#especializacion" data-content="especializacion">ÁREA DE ESPECIALIZACIÓN <span class="nav-icon">📝</span></a></li>
                        <li><a href="#grados" data-content="grados">GRADOS <span class="nav-icon">🎓</span></a></li>
                        <li><a href="#duracion" data-content="duracion">DURACIÓN DE LA CARRERA <span class="nav-icon">⏰</span></a></li>
                    </ul>
                </nav>

                <!-- Contenido dinámico -->
                <div class="carrera-content" id="carrera-content">
                    <div class="content-section active" id="perfil">
                        <h3>Perfil Profesional</h3>
                        <p>El Ingeniero Ambiental egresado de la UNSM es un profesional capacitado para identificar, evaluar y solucionar problemas ambientales, aplicando conocimientos científicos y tecnológicos para la protección, conservación y recuperación del medio ambiente.</p>
                        <ul>
                            <li>Evalúa y gestiona impactos ambientales en proyectos de desarrollo.</li>
                            <li>Diseña sistemas de tratamiento de aguas residuales y residuos sólidos.</li>
                            <li>Implementa programas de gestión ambiental en organizaciones.</li>
                            <li>Realiza estudios de calidad ambiental (aire, agua, suelo).</li>
                            <li>Desarrolla proyectos de conservación y restauración de ecosistemas.</li>
                        </ul>
                    </div>

                    <div class="content-section" id="aptitudes">
                        <h3>Aptitudes Requeridas</h3>
                        <p>El estudiante de Ingeniería Ambiental debe desarrollar las siguientes aptitudes:</p>
                        <ul>
                            <li>Interés por las ciencias naturales y el medio ambiente.</li>
                            <li>Capacidad de análisis y resolución de problemas ambientales.</li>
                            <li>Compromiso con el desarrollo sostenible.</li>
                            <li>Habilidades para el trabajo en equipo y comunicación.</li>
                            <li>Disposición para el trabajo de campo.</li>
                            <li>Pensamiento crítico e innovador.</li>
                        </ul>
                    </div>

                    <div class="content-section" id="campo">
                        <h3>Campo Laboral</h3>
                        <p>Asesoría y consultoría en proyectos ambientales. Docencia universitaria. Participación en el desarrollo del país laborando en empresas estatales y privadas en el área de medio ambiente. Diagnostica, formula, promociona, ejecuta, evalúa planes, programas y proyectos, orientados a la protección, conservación y aprovechamiento racional de los recursos naturales.</p>
                        <ul>
                            <li>Empresas consultoras ambientales.</li>
                            <li>Entidades gubernamentales (MINAM, OEFA, ANA, SERNANP).</li>
                            <li>Industrias con sistemas de gestión ambiental.</li>
                            <li>ONGs dedicadas a la conservación ambiental.</li>
                            <li>Laboratorios de análisis ambiental.</li>
                            <li>Docencia e investigación universitaria.</li>
                        </ul>
                    </div>

                    <div class="content-section" id="malla">
                        <h3>Malla Curricular</h3>
                        <p>La carrera de Ingeniería Ambiental contempla un plan de estudios de 10 semestres académicos que incluye:</p>
                        <ul>
                            <li>Estudios generales: Matemáticas, Física, Química, Biología.</li>
                            <li>Estudios específicos: Ecología, Hidrología, Meteorología.</li>
                            <li>Estudios de especialidad: Evaluación de Impacto Ambiental, Tratamiento de Aguas, Gestión de Residuos.</li>
                            <li>Prácticas pre-profesionales en instituciones del sector ambiental.</li>
                        </ul>
                    </div>

                    <div class="content-section" id="especializacion">
                        <h3>Área de Especialización</h3>
                        <p>La Escuela de Ingeniería Ambiental ofrece las siguientes áreas de especialización:</p>
                        <ul>
                            <li>Gestión Ambiental y Desarrollo Sostenible.</li>
                            <li>Tratamiento de Aguas y Efluentes.</li>
                            <li>Gestión de Residuos Sólidos.</li>
                            <li>Evaluación de Impacto Ambiental.</li>
                            <li>Conservación de Recursos Naturales.</li>
                            <li>Calidad Ambiental y Monitoreo.</li>
                        </ul>
                    </div>

                    <div class="content-section" id="grados">
                        <h3>Grados</h3>
                        <div class="carrera-info-cards">
                            <div class="info-card">
                                <div class="info-icon">📚</div>
                                <h4>Grado Académico</h4>
                                <p>Bachiller en Ingeniería Ambiental</p>
                            </div>
                            <div class="info-card">
                                <div class="info-icon">🎓</div>
                                <h4>Título Profesional</h4>
                                <p>Ingeniero Ambiental</p>
                            </div>
                        </div>
                    </div>

                    <div class="content-section" id="duracion">
                        <h3>Duración de la Carrera</h3>
                        <div class="carrera-info-cards">
                            <div class="info-card">
                                <div class="info-icon">📅</div>
                                <h4>Duración</h4>
                                <p>10 semestres académicos (5 años)</p>
                            </div>
                            <div class="info-card">
                                <div class="info-icon">📋</div>
                                <h4>Modalidad</h4>
                                <p>Presencial</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Sección Noticias Recientes -->
    <section class="noticias-section">
        <div class="noticias-container">
            <div class="noticias-header">
                <h2>Últimas Noticias</h2>
            </div>
            <div class="noticias-grid">
                <?php
                // Obtener últimas noticias desde WordPress
                $noticias_args = array(
                    'post_type'      => 'post',
                    'posts_per_page' => 3,
                    'orderby'        => 'date',
                    'order'          => 'DESC',
                    'post_status'    => 'publish'
                );

                $noticias_query = new WP_Query($noticias_args);

                if ($noticias_query->have_posts()) :
                    while ($noticias_query->have_posts()) : $noticias_query->the_post();
                        $categorias = get_the_category();
                        $categoria_nombre = !empty($categorias) ? $categorias[0]->name : 'NOTICIA';
                ?>
                    <article class="noticia-card">
                        <div class="noticia-image">
                            <?php if (has_post_thumbnail()) : ?>
                                <?php the_post_thumbnail('medium', array('alt' => get_the_title(), 'loading' => 'lazy')); ?>
                            <?php else : ?>
                                <img src="../imagenes/ambiental-banner.jpg" alt="<?php echo esc_attr(get_the_title()); ?>" loading="lazy">
                            <?php endif; ?>
                            <span class="noticia-badge"><?php echo esc_html(strtoupper($categoria_nombre)); ?></span>
                        </div>
                        <div class="noticia-content">
                            <h3><?php the_title(); ?></h3>
                            <p><?php echo wp_trim_words(get_the_excerpt(), 20, '...'); ?></p>
                            <a href="<?php the_permalink(); ?>" class="noticia-link">Leer más →</a>
                        </div>
                    </article>
                <?php
                    endwhile;
                    wp_reset_postdata();
                else :
                ?>
                    <p class="no-noticias">No hay noticias disponibles en este momento.</p>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central Telefónica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="../../../admision/indexAdmin.php">Admisión</a></li>
                    <li><a href="../../../index.php#facultades">Facultades</a></li>
                    <li><a href="../../../index.php#posgrado">Posgrado</a></li>
                    <li><a href="../../../index.php#investigacion">Investigación</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../../../index.php#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../../../index.php#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../../../index.php#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../../../index.php#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../../../index.php#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Martín - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2026 Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>

    <script src="../../../js/script.js" defer></script>
    <script>
        // Tabs functionality
        document.addEventListener('DOMContentLoaded', function() {
            // Tabs de la sección ESCUELA
            const tabButtons = document.querySelectorAll('.tab-button');
            const tabContents = document.querySelectorAll('.tabs-content .tab-content');

            tabButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const targetTab = this.getAttribute('data-tab');

                    tabButtons.forEach(btn => btn.classList.remove('active'));
                    tabContents.forEach(content => content.classList.remove('active'));

                    this.classList.add('active');
                    document.getElementById(targetTab).classList.add('active');
                });
            });

            // Navegación del sidebar de carrera
            const sidebarLinks = document.querySelectorAll('.sidebar-nav a');
            const contentSections = document.querySelectorAll('.content-section');

            sidebarLinks.forEach(link => {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    const targetContent = this.getAttribute('data-content');

                    sidebarLinks.forEach(l => l.classList.remove('active'));
                    contentSections.forEach(section => section.classList.remove('active'));

                    this.classList.add('active');
                    document.getElementById(targetContent).classList.add('active');
                });
            });
        });
    </script>

    <style>
        /* Estilos adicionales para las secciones de contenido */
        .content-section {
            display: none;
        }
        .content-section.active {
            display: block;
            animation: fadeIn 0.5s ease;
        }
    </style>
</body>
</html>
