<?php
session_start();
require_once 'auth/authenticate.php';

// Verificar autenticación
require_authentication();

// Obtener información del usuario
$username = $_SESSION['username'] ?? 'Usuario';
$role = $_SESSION['user_role'] ?? 'estudiante';

// Traducir rol
$role_labels = [
    'admin' => 'Administrador',
    'docente' => 'Docente',
    'estudiante' => 'Estudiante'
];
$role_label = $role_labels[$role] ?? 'Usuario';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - UNSM</title>
    <link rel="icon" type="image/png" href="imagenes/escudo unsm.png" sizes="48x48">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 16px;
            padding: 40px;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
        }

        .dashboard-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 40px;
            padding-bottom: 20px;
            border-bottom: 2px solid #e5e7eb;
        }

        .dashboard-title {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .dashboard-title img {
            width: 60px;
            height: auto;
        }

        .dashboard-title h1 {
            font-size: 2rem;
            color: #1f2937;
        }

        .user-info {
            text-align: right;
        }

        .user-welcome {
            font-size: 1.1rem;
            color: #4b5563;
            margin-bottom: 5px;
        }

        .user-role {
            display: inline-block;
            padding: 6px 16px;
            background: #359444;
            color: white;
            border-radius: 20px;
            font-size: 0.9rem;
            font-weight: 600;
        }

        .dashboard-content {
            margin-bottom: 30px;
        }

        .success-message {
            background: #f0fdf4;
            border: 1px solid #bbf7d0;
            color: #16a34a;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .success-icon {
            width: 24px;
            height: 24px;
            flex-shrink: 0;
        }

        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .dashboard-card {
            background: linear-gradient(135deg, #359444 0%, #2a7535 100%);
            color: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            transition: transform 0.2s;
        }

        .dashboard-card:hover {
            transform: translateY(-5px);
        }

        .dashboard-card h3 {
            font-size: 1.3rem;
            margin-bottom: 10px;
        }

        .dashboard-card p {
            opacity: 0.9;
            line-height: 1.6;
        }

        .action-buttons {
            display: flex;
            gap: 15px;
            margin-top: 30px;
            flex-wrap: wrap;
        }

        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            display: inline-block;
        }

        .btn-primary {
            background: #359444;
            color: white;
        }

        .btn-primary:hover {
            background: #2a7535;
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: #6b7280;
            color: white;
        }

        .btn-secondary:hover {
            background: #4b5563;
        }

        .btn-danger {
            background: #dc2626;
            color: white;
        }

        .btn-danger:hover {
            background: #b91c1c;
        }

        @media (max-width: 768px) {
            .dashboard-header {
                flex-direction: column;
                text-align: center;
            }

            .user-info {
                text-align: center;
                margin-top: 20px;
            }

            .dashboard-title h1 {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <div class="dashboard-header">
            <div class="dashboard-title">
                <img src="imagenes/escudo unsm.png" alt="UNSM">
                <div>
                    <h1>Dashboard UNSM</h1>
                </div>
            </div>
            <div class="user-info">
                <div class="user-welcome">Bienvenido, <strong><?php echo htmlspecialchars($username); ?></strong></div>
                <span class="user-role"><?php echo htmlspecialchars($role_label); ?></span>
            </div>
        </div>

        <div class="dashboard-content">
            <div class="success-message">
                <svg class="success-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path>
                    <polyline points="22 4 12 14.01 9 11.01"></polyline>
                </svg>
                <div>
                    <strong>Sesión iniciada correctamente</strong>
                    <p>Has accedido exitosamente al sistema de gestión académica de la UNSM.</p>
                </div>
            </div>

            <h2 style="margin-bottom: 20px; color: #1f2937;">Panel de Control</h2>

            <div class="cards-grid">
                <div class="dashboard-card">
                    <h3>Mis Cursos</h3>
                    <p>Accede a tus cursos matriculados y revisa el material académico disponible.</p>
                </div>

                <div class="dashboard-card">
                    <h3>Calificaciones</h3>
                    <p>Consulta tus notas y el historial académico de todos tus cursos.</p>
                </div>

                <div class="dashboard-card">
                    <h3>Horarios</h3>
                    <p>Revisa tu horario de clases y las fechas importantes del semestre.</p>
                </div>

                <div class="dashboard-card">
                    <h3>Biblioteca Virtual</h3>
                    <p>Accede a recursos bibliográficos y materiales de estudio digitales.</p>
                </div>
            </div>

            <div class="action-buttons">
                <a href="index.php" class="btn btn-primary">Ir al Portal Principal</a>
                <a href="#" class="btn btn-secondary">Mi Perfil</a>
                <a href="logout.php" class="btn btn-danger">Cerrar Sesión</a>
            </div>
        </div>
    </div>
</body>
</html>
