<?php
/**
 * Configuración de Base de Datos
 * Universidad Nacional de San Martín - UNSM
 */

// Configuración de base de datos
define('DB_HOST', 'localhost');
define('DB_USER', 'root');          // Cambiar según tu configuración
define('DB_PASS', '');              // Cambiar según tu configuración
define('DB_NAME', 'unsm_db');       // Cambiar según tu configuración
define('DB_CHARSET', 'utf8mb4');

/**
 * Obtiene una conexión a la base de datos
 * @return mysqli Conexión a la base de datos
 */
function get_db_connection() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

    // Verificar conexión
    if ($conn->connect_error) {
        error_log("Error de conexión a la base de datos: " . $conn->connect_error);
        throw new Exception("Error al conectar con la base de datos");
    }

    // Establecer charset
    $conn->set_charset(DB_CHARSET);

    return $conn;
}

/**
 * Ejecuta una consulta SQL de forma segura
 */
function execute_query($sql, $params = [], $types = "") {
    $conn = get_db_connection();

    if (!empty($params)) {
        $stmt = $conn->prepare($sql);
        $stmt->bind_param($types, ...$params);
        $stmt->execute();
        $result = $stmt->get_result();
        $stmt->close();
    } else {
        $result = $conn->query($sql);
    }

    $conn->close();

    return $result;
}
