<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Admisión - Universidad Nacional de San Martín - UNSM">
    <meta name="keywords" content="UNSM, Admisión, Universidad San Martín, Postulantes, Proceso de Admisión">
    <meta name="author" content="Universidad Nacional de San Martín">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#359444">

    <title>Admisión - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../css/style.css">
    <!-- Stylesheet Admisión -->
    <link rel="stylesheet" href="css/styleAdmin.css?v=1.1">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en Facebook" aria-label="Página oficial de Facebook de la UNSM">
                    <img src="../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Síguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Síguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../imagenes/logo telefono.png" alt="Teléfono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../" aria-label="Ir a la página principal de UNSM">
                    <img src="../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martín" width="auto" height="70">
                </a>
            </div>

            <!-- Botón Hamburguesa para móvil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menú de navegación" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">
                <div class="mobile-nav-logo">
                    <img src="../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="../#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menú Nosotros">
                            <li><a href="../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../nosotros/mision/indexMision.php">Nuestra Misión y Visión</a></li>
                            <li><a href="../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../nosotros/calendarioAcade/indexCale.php">Calendario Académico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="../#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Académico</a></li>
                                <li><a href="../oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigación</a></li>
                                <li><a href="../oficinas/secretaria general/indexSecreGene.php">Secretaría General</a></li>
                                <li><a href="../oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicación e Imagen Institucional</a></li>
                                <li><a href="../oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperación y Relaciones Internacionales</a></li>
                                <li><a href="../oficinas/Organo de Control Institucional/indexOrgaConIns.php">Órgano de Control Institucional</a></li>
                                <li><a href="../oficinas/Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../oficinas/Asesoria Juridica/indexAseJuri.php">Asesoría Jurídica</a></li>
                                <li><a href="../oficinas/Grados y Titulos/indexGrados.php">Grados y Títulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Académicas</li>
                                <li><a href="./">Oficina de Admisión</a></li>
                                <li><a href="../oficinas/Academicos/ASUNTOS ACADEMICOS/indexAsunAca.php">Asuntos Académicos</a></li>
                                <li><a href="../oficinas/Academicos/Seguimiento al Egresado e Insercion Laboral/indexSegui.php">Seguimiento al Egresado e Inserción Laboral</a></li>
                                <li><a href="../oficinas/Academicos/TECNOLOGIAS DE LA INFORMACION/indexOTI.php">Tecnologías de la Información</a></li>
                                <li><a href="../oficinas/Academicos/FONDO EDITORIAL/indexFondo.php">Fondo Editorial</a></li>
                                <li><a href="../#comite-electoral">Comité Electoral Universitario</a></li>
                                <li><a href="../#innovacion">Innovación y Transferencia Tecnológica</a></li>
                                <li><a href="../#produccion">Producción de Bienes y Servicios</a></li>
                                <li><a href="../#responsabilidad">Responsabilidad Social Universitaria</a></li>
                                <li><a href="../#servicios-generales">Servicios Generales</a></li>
                                <li><a href="../#bienestar">Bienestar Universitario</a></li>
                                <li><a href="../#defensoria">Defensoría Universitaria</a></li>
                                <li><a href="../#calidad">Gestión de la Calidad</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../#admision">ADMISIÓN</a></li>
                    <li><a href="../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menú Facultades">
                            <li class="has-submenu">
                                <a href="../#ciencias-agrarias" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../#agronomia">Agronomía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="../#obstetricia">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingeniería Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Agroindustrial">
                                    <li><a href="../#ing-agroindustrial">Ingeniería Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingeniería Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Civil y Arquitectura">
                                    <li><a href="../#arquitectura">Arquitectura</a></li>
                                    <li><a href="../#ingenieria-civil-carrera">Ingeniería Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingeniería de Sistemas e Informática</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería de Sistemas">
                                    <li><a href="../#ing-sistemas">Ingeniería de Sistemas e Informática</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../#ecologia" aria-haspopup="true" aria-expanded="false">Ecología</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecología">
                                    <li><a href="../#ing-ambiental">Ingeniería Ambiental</a></li>
                                    <li><a href="../#ing-sanitaria">Ingeniería Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Políticas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="../#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="../#medicina-humana-carrera">Medicina Humana</a></li>
                                    <li><a href="../#enfermeria">Enfermería</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Económicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Económicas">
                                    <li><a href="../#administracion">Administración</a></li>
                                    <li><a href="../#contabilidad">Contabilidad</a></li>
                                    <li><a href="../#economia">Economía</a></li>
                                    <li><a href="../#turismo">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../#educacion" aria-haspopup="true" aria-expanded="false">Educación y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educación">
                                    <li><a href="../#educacion-inicial">Educación Inicial</a></li>
                                    <li><a href="../#educacion-primaria">Educación Primaria</a></li>
                                    <li><a href="../#educacion-secundaria">Educación Secundaria</a></li>
                                    <li><a href="../#idiomas">Idiomas</a></li>
                                    <li>
                                        <a href="../#psicologia">
                                            Psicología
                                            <span class="badge-nuevo">Nuevo</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="../#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Menú Transparencia">
                            <li><a href="../#licenciamiento">Licenciamiento</a></li>
                            <li><a href="../#institucional">Institucional Ley 30220</a></li>
                            <li><a href="../#estandar">Estándar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Perú">
                        <img src="../imagenes/logo gobPe.png" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Perú">
                    <img src="../imagenes/logo gobPe.png" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Admisión -->
    <section class="admision-banner">
        <div class="banner-container">
            <h1>ADMISIÓN UNSM</h1>
            <div class="banner-contact">
                <p><strong>Local Universitario Jr. Amorarca Nº 315 Morales, Perú</strong></p>
                <p>admision@unsm.edu.pe</p>
            </div>
        </div>
    </section>

    <!-- Contenido Principal -->
    <main class="admision-main">
        <div class="admision-container">
            <!-- Sidebar con tabs -->
            <aside class="admision-sidebar">
                <nav class="tabs-menu">
                    <button class="tab-button active" data-tab="inicio">
                        <span class="tab-icon">🏠</span>
                        <span class="tab-text">INICIO</span>
                    </button>
                    <button class="tab-button" data-tab="sedes">
                        <span class="tab-icon">📍</span>
                        <span class="tab-text">SEDES</span>
                    </button>
                    <button class="tab-button" data-tab="requisitos">
                        <span class="tab-icon">📋</span>
                        <span class="tab-text">REQUISITOS</span>
                    </button>
                    <button class="tab-button" data-tab="cronograma">
                        <span class="tab-icon">📅</span>
                        <span class="tab-text">CRONOGRAMA</span>
                    </button>
                    <button class="tab-button" data-tab="modalidades">
                        <span class="tab-icon">📝</span>
                        <span class="tab-text">MODALIDADES</span>
                    </button>
                    <button class="tab-button" data-tab="reglamento">
                        <span class="tab-icon">📃</span>
                        <span class="tab-text">REGLAMENTOS</span>
                    </button>
                    <button class="tab-button" data-tab="preguntas">
                        <span class="tab-icon">❓</span>
                        <span class="tab-text">PREGUNTAS FRECUENTES</span>
                    </button>
                </nav>
            </aside>

            <!-- Contenido principal -->
            <div class="admision-content">
                <!-- Tab de Inicio -->
                <div class="tab-content active" id="inicio">
                    <div class="content-wrapper">
                        <div class="proceso-section">
                            <h2>SEDES Y ESCUELAS<br><span class="proceso-subtitle">PROCESO DE ADMISIÓN 2026-I</span></h2>

                            <div class="sedes-grid">
                                <!-- Sede Morales -->
                                <div class="sede-card collapsible">
                                    <div class="sede-header">
                                        <div class="sede-icon">
                                            <svg width="40" height="55" viewBox="0 0 40 55" fill="none">
                                                <path d="M20 0C8.954 0 0 8.954 0 20c0 14.5 20 35 20 35s20-20.5 20-35c0-11.046-8.954-20-20-20z" fill="#F5C518"/>
                                                <circle cx="20" cy="20" r="8" fill="white"/>
                                            </svg>
                                        </div>
                                        <div class="sede-header-content">
                                            <h3>MORALES</h3>
                                            <p class="sede-subtitle">Carreras profesionales</p>
                                        </div>
                                        <button class="sede-toggle" aria-label="Mostrar/Ocultar carreras">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <polyline points="6 9 12 15 18 9"></polyline>
                                            </svg>
                                        </button>
                                    </div>
                                    <div class="sede-content">
                                        <ul class="carreras-list">
                                            <li>Agronomía</li>
                                            <li>Arquitectura</li>
                                            <li>Enfermería</li>
                                            <li>Obstetricia</li>
                                            <li>Derecho</li>
                                            <li>Administración</li>
                                            <li>Contabilidad</li>
                                            <li>Economía</li>
                                            <li>Ingeniería Civil</li>
                                            <li>Ingeniería Ambiental</li>
                                            <li>Ingeniería Sanitaria</li>
                                            <li>Medicina Humana</li>
                                            <li>Medicina Veterinaria</li>
                                        </ul>
                                    </div>
                                </div>

                                <!-- Sede Rioja -->
                                <div class="sede-card collapsible">
                                    <div class="sede-header">
                                        <div class="sede-icon">
                                            <svg width="40" height="55" viewBox="0 0 40 55" fill="none">
                                                <path d="M20 0C8.954 0 0 8.954 0 20c0 14.5 20 35 20 35s20-20.5 20-35c0-11.046-8.954-20-20-20z" fill="#F5C518"/>
                                                <circle cx="20" cy="20" r="8" fill="white"/>
                                            </svg>
                                        </div>
                                        <div class="sede-header-content">
                                            <h3>RIOJA</h3>
                                            <p class="sede-subtitle">Carreras profesionales</p>
                                        </div>
                                        <button class="sede-toggle" aria-label="Mostrar/Ocultar carreras">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <polyline points="6 9 12 15 18 9"></polyline>
                                            </svg>
                                        </button>
                                    </div>
                                    <div class="sede-content">
                                        <ul class="carreras-list">
                                            <li>Ingeniería Agroindustrial</li>
                                            <li>Ingeniería de Sistemas e Informática</li>
                                            <li>Educación Primaria</li>
                                            <li>Educación Secundaria</li>
                                            <li>Idiomas</li>
                                            <li>
                                                Psicología
                                                <span class="badge-nuevo">Nuevo</span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>

                                <!-- Sede Moyobamba -->
                                <div class="sede-card collapsible">
                                    <div class="sede-header">
                                        <div class="sede-icon">
                                            <svg width="40" height="55" viewBox="0 0 40 55" fill="none">
                                                <path d="M20 0C8.954 0 0 8.954 0 20c0 14.5 20 35 20 35s20-20.5 20-35c0-11.046-8.954-20-20-20z" fill="#F5C518"/>
                                                <circle cx="20" cy="20" r="8" fill="white"/>
                                            </svg>
                                        </div>
                                        <div class="sede-header-content">
                                            <h3>MOYOBAMBA</h3>
                                            <p class="sede-subtitle">Carreras profesionales</p>
                                        </div>
                                        <button class="sede-toggle" aria-label="Mostrar/Ocultar carreras">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <polyline points="6 9 12 15 18 9"></polyline>
                                            </svg>
                                        </button>
                                    </div>
                                    <div class="sede-content">
                                        <ul class="carreras-list">
                                            <li>Ingeniería Ambiental</li>
                                            <li>Ingeniería Sanitaria</li>
                                        </ul>
                                    </div>
                                </div>

                                <!-- Sede Lamas -->
                                <div class="sede-card collapsible">
                                    <div class="sede-header">
                                        <div class="sede-icon">
                                            <svg width="40" height="55" viewBox="0 0 40 55" fill="none">
                                                <path d="M20 0C8.954 0 0 8.954 0 20c0 14.5 20 35 20 35s20-20.5 20-35c0-11.046-8.954-20-20-20z" fill="#F5C518"/>
                                                <circle cx="20" cy="20" r="8" fill="white"/>
                                            </svg>
                                        </div>
                                        <div class="sede-header-content">
                                            <h3>LAMAS</h3>
                                            <p class="sede-subtitle">Carreras profesionales</p>
                                        </div>
                                        <button class="sede-toggle" aria-label="Mostrar/Ocultar carreras">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <polyline points="6 9 12 15 18 9"></polyline>
                                            </svg>
                                        </button>
                                    </div>
                                    <div class="sede-content">
                                        <ul class="carreras-list">
                                            <li>Turismo</li>
                                        </ul>
                                    </div>
                                </div>

                                <!-- Sede La Banda de Shilcayo -->
                                <div class="sede-card collapsible">
                                    <div class="sede-header">
                                        <div class="sede-icon">
                                            <svg width="40" height="55" viewBox="0 0 40 55" fill="none">
                                                <path d="M20 0C8.954 0 0 8.954 0 20c0 14.5 20 35 20 35s20-20.5 20-35c0-11.046-8.954-20-20-20z" fill="#F5C518"/>
                                                <circle cx="20" cy="20" r="8" fill="white"/>
                                            </svg>
                                        </div>
                                        <div class="sede-header-content">
                                            <h3>LA BANDA DE SHILCAYO</h3>
                                            <p class="sede-subtitle">Carreras profesionales</p>
                                        </div>
                                        <button class="sede-toggle" aria-label="Mostrar/Ocultar carreras">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <polyline points="6 9 12 15 18 9"></polyline>
                                            </svg>
                                        </button>
                                    </div>
                                    <div class="sede-content">
                                        <ul class="carreras-list">
                                            <li>Educación Secundaria</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Widget de Postulación -->
                    <aside class="postulacion-widget">
                        <h3>Próximos Eventos</h3>
                        <div class="evento-container">
                            <div class="evento-item">
                                <span class="evento-fecha">15 ENE</span>
                                <span class="evento-nombre">Inicio de Inscripciones</span>
                            </div>
                            <div class="evento-item">
                                <span class="evento-fecha">28 FEB</span>
                                <span class="evento-nombre">Cierre de Inscripciones</span>
                            </div>
                        </div>

                        <a href="#" class="btn-postula">POSTULA AQUÍ</a>

                        <div class="contacto-box">
                            <h4>Contáctanos</h4>
                            <p><strong>Dirección:</strong> Jr. Amorarca N° 315, Morales San Martín - Perú</p>
                            <p><strong>Teléfonos:</strong> 042 52 3991 - 042 52 3992</p>
                            <p><strong>Whatsapp:</strong> 999 365 353 ext. 101 al 102</p>
                        </div>
                    </aside>
                </div>

                <!-- Tab de Sedes -->
                <div class="tab-content" id="sedes">
                    <div class="content-wrapper">
                        <h2>NUESTRAS SEDES</h2>
                        <p>La Universidad Nacional de San Martín cuenta con 5 sedes distribuidas estratégicamente en la región:</p>

                        <div class="info-sedes">
                            <div class="sede-detalle">
                                <h3>Sede Morales (Principal)</h3>
                                <p><strong>Ubicación:</strong> Jr. Maynas N° 177 - Morales</p>
                                <p><strong>Carreras:</strong> 13 carreras profesionales disponibles</p>
                            </div>

                            <div class="sede-detalle">
                                <h3>Sede Rioja</h3>
                                <p><strong>Ubicación:</strong> Jr. Tarapoto - Rioja</p>
                                <p><strong>Carreras:</strong> 5 carreras profesionales disponibles</p>
                            </div>

                            <div class="sede-detalle">
                                <h3>Sede Moyobamba</h3>
                                <p><strong>Ubicación:</strong> Moyobamba</p>
                                <p><strong>Carreras:</strong> 2 carreras profesionales disponibles</p>
                            </div>

                            <div class="sede-detalle">
                                <h3>Sede Lamas</h3>
                                <p><strong>Ubicación:</strong> Lamas</p>
                                <p><strong>Carreras:</strong> 1 carrera profesional disponible</p>
                            </div>

                            <div class="sede-detalle">
                                <h3>Sede La Banda de Shilcayo</h3>
                                <p><strong>Ubicación:</strong> La Banda de Shilcayo</p>
                                <p><strong>Carreras:</strong> 1 carrera profesional disponible</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tab de Requisitos -->
                <div class="tab-content" id="requisitos">
                    <div class="content-wrapper">
                        <h2>REQUISITOS PARA POSTULAR</h2>

                        <div class="requisitos-section">
                            <h3>Documentos Obligatorios:</h3>
                            <ul class="requisitos-list">
                                <li>Certificado de estudios original de educación secundaria</li>
                                <li>Partida de nacimiento original</li>
                                <li>Copia del DNI vigente</li>
                                <li>Dos fotografías tamaño carnet a color fondo blanco</li>
                                <li>Recibo de pago por derecho de inscripción</li>
                                <li>Ficha de inscripción debidamente llena</li>
                            </ul>

                            <h3>Requisitos Adicionales por Modalidad:</h3>
                            <p>Algunos requisitos adicionales pueden aplicar dependiendo de la modalidad de ingreso seleccionada. Consulta la sección de MODALIDADES para más información.</p>
                        </div>
                    </div>
                </div>

                <!-- Tab de Cronograma -->
                <div class="tab-content" id="cronograma">
                    <div class="content-wrapper">
                        <h2>CRONOGRAMA DE ADMISIÓN 2024-I</h2>

                        <div class="cronograma-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Actividad</th>
                                        <th>Fecha</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Inicio de inscripciones</td>
                                        <td>15 de Enero 2024</td>
                                    </tr>
                                    <tr>
                                        <td>Cierre de inscripciones</td>
                                        <td>28 de Febrero 2024</td>
                                    </tr>
                                    <tr>
                                        <td>Publicación de aulas</td>
                                        <td>05 de Marzo 2024</td>
                                    </tr>
                                    <tr>
                                        <td>Examen de admisión</td>
                                        <td>10 de Marzo 2024</td>
                                    </tr>
                                    <tr>
                                        <td>Publicación de resultados</td>
                                        <td>12 de Marzo 2024</td>
                                    </tr>
                                    <tr>
                                        <td>Proceso de matrícula</td>
                                        <td>20-25 de Marzo 2024</td>
                                    </tr>
                                    <tr>
                                        <td>Inicio de clases</td>
                                        <td>01 de Abril 2024</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Tab de Modalidades -->
                <div class="tab-content" id="modalidades">
                    <div class="content-wrapper">
                        <h2>MODALIDADES DE ADMISIÓN</h2>

                        <div class="modalidades-section">
                            <div class="modalidad-item">
                                <h3>Ordinario</h3>
                                <p>Dirigido a egresados de educación secundaria. El ingreso se determina mediante examen de conocimientos.</p>
                            </div>

                            <div class="modalidad-item">
                                <h3>Centro Preuniversitario - CPU</h3>
                                <p>Para estudiantes que han culminado satisfactoriamente el Centro Preuniversitario de la UNSM.</p>
                            </div>

                            <div class="modalidad-item">
                                <h3>Primera y Segunda Opción</h3>
                                <p>Para estudiantes que han aprobado cuatro semestres académicos en otra universidad. Ingreso por examen de conocimientos.</p>
                            </div>

                            <div class="modalidad-item">
                                <h3>Titulados o Graduados</h3>
                                <p>Para profesionales con título profesional o grado de bachiller universitario.</p>
                            </div>

                            <div class="modalidad-item">
                                <h3>Traslado Interno</h3>
                                <p>Para estudiantes de la UNSM que desean cambiar de escuela profesional.</p>
                            </div>

                            <div class="modalidad-item">
                                <h3>Traslado Externo</h3>
                                <p>Para estudiantes procedentes de otras universidades del país o del extranjero.</p>
                            </div>

                            <div class="modalidad-item">
                                <h3>Dos Primeros Puestos</h3>
                                <p>Para estudiantes que ocuparon el primer o segundo puesto de su promoción en educación secundaria.</p>
                            </div>

                            <div class="modalidad-item">
                                <h3>Víctimas del Terrorismo</h3>
                                <p>Beneficio especial para hijos de víctimas del terrorismo según Ley N° 27277.</p>
                            </div>

                            <div class="modalidad-item">
                                <h3>Deportistas Calificados</h3>
                                <p>Para deportistas destacados a nivel nacional o internacional.</p>
                            </div>

                            <div class="modalidad-item">
                                <h3>Personas con Discapacidad</h3>
                                <p>Beneficio especial para personas con discapacidad según normativa vigente.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tab de Reglamentos -->
                <div class="tab-content" id="reglamento">
                    <div class="content-wrapper">
                        <h2>REGLAMENTOS Y NORMATIVAS</h2>
                        <p>Documentos oficiales que rigen el proceso de admisión:</p>
                        <ul class="documentos-list">
                            <li>
                                <a href="#" class="documento-link">
                                    <span class="doc-icon">📄</span>
                                    <span class="doc-nombre">Reglamento de Admisión 2024</span>
                                </a>
                            </li>
                            <li>
                                <a href="#" class="documento-link">
                                    <span class="doc-icon">📄</span>
                                    <span class="doc-nombre">Prospecto de Admisión 2024-I</span>
                                </a>
                            </li>
                            <li>
                                <a href="#" class="documento-link">
                                    <span class="doc-icon">📄</span>
                                    <span class="doc-nombre">Guía del Postulante</span>
                                </a>
                            </li>
                            <li>
                                <a href="#" class="documento-link">
                                    <span class="doc-icon">📄</span>
                                    <span class="doc-nombre">Temario del Examen de Admisión</span>
                                </a>
                            </li>
                            <li>
                                <a href="#" class="documento-link">
                                    <span class="doc-icon">📄</span>
                                    <span class="doc-nombre">Ley Universitaria 30220</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Tab de Preguntas Frecuentes -->
                <div class="tab-content" id="preguntas">
                    <div class="content-wrapper">
                        <h2>PREGUNTAS FRECUENTES</h2>

                        <div class="faq-section">
                            <div class="faq-item">
                                <h3>¿Cuándo inicia el proceso de admisión?</h3>
                                <p>El proceso de inscripción inicia el 15 de enero y se extiende hasta el 28 de febrero de 2026.</p>
                            </div>

                            <div class="faq-item">
                                <h3>¿Cuál es el costo de inscripción?</h3>
                                <p>El costo varía según la modalidad de ingreso. Para conocer los costos específicos, acércate a nuestras oficinas o llama a los teléfonos indicados.</p>
                            </div>

                            <div class="faq-item">
                                <h3>¿Puedo postular a más de una carrera?</h3>
                                <p>Sí, puedes elegir hasta dos opciones de carrera profesional al momento de inscribirte.</p>
                            </div>

                            <div class="faq-item">
                                <h3>¿Cuántas vacantes hay por carrera?</h3>
                                <p>El número de vacantes varía por carrera y se publica en el prospecto de admisión. Generalmente oscilan entre 25 y 45 vacantes por carrera.</p>
                            </div>

                            <div class="faq-item">
                                <h3>¿Cómo puedo prepararme para el examen?</h3>
                                <p>Recomendamos revisar el temario publicado y considerar inscribirte en nuestro Centro Preuniversitario (CPU).</p>
                            </div>

                            <div class="faq-item">
                                <h3>¿Qué sucede si no alcanzo vacante en mi primera opción?</h3>
                                <p>Serás considerado automáticamente para tu segunda opción si alcanzas el puntaje mínimo requerido.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central Telefónica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="../#admision">Admisión</a></li>
                    <li><a href="../#facultades">Facultades</a></li>
                    <li><a href="../#posgrado">Posgrado</a></li>
                    <li><a href="../#investigacion">Investigación</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <!-- Plugin de Facebook -->
                <div class="fb-page" data-href="https://www.facebook.com/unsmperu" data-tabs="timeline" data-width="" data-height="" data-small-header="false" data-adapt-container-width="true" data-hide-cover="false" data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <!-- Chatbot de Ayuda UNSM -->
    <?php include(__DIR__ . '/../includes/chatbot-widget.php'); ?>

    <script src="../js/script.js" defer></script>
    <script src="../js/chatbot-data.js" defer></script>
    <script src="../js/chatbot.js" defer></script>
    <script src="js/scriptAdmin.js?v=1.2" defer></script>
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>
</body>
</html>
