<?php
// Cargar WordPress
require_once(__DIR__ . '/../wordpress/wp-load.php');

// Paginación
$paged = isset($_GET['pag']) ? max(1, intval($_GET['pag'])) : 1;
$posts_per_page = 9;
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Noticias de la Universidad Nacional de San Martín - UNSM. Mantente informado sobre eventos, actividades académicas y más.">
    <meta name="keywords" content="noticias UNSM, universidad San Martín, eventos universitarios, actividades académicas">
    <title>Noticias - Universidad Nacional de San Martín | UNSM</title>

    <link rel="icon" type="image/png" href="../imagenes/escudo unsm.png" sizes="48x48">
    <link rel="stylesheet" href="../css/style.css">

    <style>
        .noticias-hero {
            background: linear-gradient(135deg, var(--color-primary-dark) 0%, var(--color-primary) 100%);
            padding: 60px 20px;
            text-align: center;
            color: white;
        }

        .noticias-hero h1 {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }

        .noticias-hero p {
            font-size: 1.1rem;
            opacity: 0.9;
        }

        .noticias-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 40px 20px;
        }

        .noticias-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
        }

        .noticia-card {
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .noticia-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        }

        .noticia-card a {
            text-decoration: none;
            color: inherit;
            display: block;
        }

        .noticia-imagen {
            position: relative;
            height: 200px;
            overflow: hidden;
        }

        .noticia-imagen img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s ease;
        }

        .noticia-card:hover .noticia-imagen img {
            transform: scale(1.05);
        }

        .noticia-categoria {
            position: absolute;
            top: 15px;
            left: 15px;
            background: var(--color-primary);
            color: white;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
        }

        .noticia-contenido {
            padding: 20px;
        }

        .noticia-fecha {
            color: var(--color-text-light);
            font-size: 0.85rem;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .noticia-titulo {
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--color-text-dark);
            margin-bottom: 10px;
            line-height: 1.4;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .noticia-extracto {
            color: var(--color-text-light);
            font-size: 0.9rem;
            line-height: 1.6;
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
            margin-bottom: 15px;
        }

        .noticia-leer-mas {
            display: inline-block;
            background: var(--color-primary);
            color: white;
            padding: 8px 20px;
            border-radius: 25px;
            font-size: 0.85rem;
            font-weight: 600;
            transition: background 0.3s ease;
        }

        .noticia-card:hover .noticia-leer-mas {
            background: var(--color-primary-dark);
        }

        /* Paginación */
        .paginacion {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            margin-top: 50px;
            flex-wrap: wrap;
        }

        .paginacion a,
        .paginacion span {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 40px;
            height: 40px;
            padding: 0 12px;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .paginacion a {
            background: white;
            color: var(--color-text);
            border: 2px solid #e0e0e0;
        }

        .paginacion a:hover {
            background: var(--color-primary);
            color: white;
            border-color: var(--color-primary);
        }

        .paginacion .actual {
            background: var(--color-primary);
            color: white;
            border: 2px solid var(--color-primary);
        }

        .paginacion .prev-next {
            background: var(--color-primary);
            color: white;
            border: 2px solid var(--color-primary);
        }

        .paginacion .prev-next:hover {
            background: var(--color-primary-dark);
            border-color: var(--color-primary-dark);
        }

        .no-noticias {
            text-align: center;
            padding: 60px 20px;
            color: var(--color-text-light);
        }

        .no-noticias h2 {
            font-size: 1.5rem;
            margin-bottom: 10px;
            color: var(--color-text);
        }

        .btn-volver {
            display: inline-block;
            background: var(--color-primary);
            color: white;
            padding: 12px 30px;
            border-radius: 25px;
            text-decoration: none;
            font-weight: 600;
            margin-top: 20px;
            transition: background 0.3s ease;
        }

        .btn-volver:hover {
            background: var(--color-primary-dark);
        }

        /* Responsive */
        @media (max-width: 992px) {
            .noticias-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 600px) {
            .noticias-hero h1 {
                font-size: 1.8rem;
            }

            .noticias-grid {
                grid-template-columns: 1fr;
            }

            .noticia-imagen {
                height: 180px;
            }
        }
    </style>
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Facebook">
                    <img src="../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Instagram">
                    <img src="../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu" target="_blank" rel="noopener noreferrer" title="YouTube">
                    <img src="../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="X">
                    <img src="../imagenes/redes/logo x.png" alt="X" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm" target="_blank" rel="noopener noreferrer" title="TikTok">
                    <img src="../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../imagenes/logo telefono.png" alt="Teléfono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../index.php" aria-label="Ir a la página principal de UNSM">
                    <img src="../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="70">
                </a>
            </div>

            <button class="mobile-menu-toggle" aria-label="Abrir menú" aria-expanded="false">
                <span></span>
                <span></span>
                <span></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">

                <!-- Logo en menú móvil -->
                <div class="mobile-nav-logo">
                    <img src="../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menú Nosotros">
                            <li><a href="../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../nosotros/mision/indexMision.php">Nuestra Misión y Visión</a></li>
                            <li><a href="../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../nosotros/calendarioAcade/indexCale.php">Calendario Acad&eacute;mico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Académico</a></li>
                                <li><a href="../oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigación</a></li>
                                <li><a href="../oficinas/secretaria general/indexSecreGene.php">Secretaría General</a></li>
                                <li><a href="../oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicación e Imagen Institucional</a></li>
                                <li><a href="../oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperación y Relaciones Internacionales</a></li>
                                <li><a href="../oficinas/Organo de Control Institucional/indexOrgaConIns.php">Órgano de Control Institucional</a></li>
                                <li><a href="../oficinas/Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../oficinas/Asesoria Juridica/indexAseJuri.php">Asesoría Jurídica</a></li>
                                <li><a href="../oficinas/Grados y Titulos/indexGrados.php">Grados y Títulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Académicas</li>
                                <li><a href="../oficinas/Academicos/OFICINA DE ADMISION/indexOfiAdmin.php">Oficina de Admisión</a></li>
                                <li><a href="../oficinas/Academicos/ASUNTOS ACADEMICOS/indexAsunAca.php">Asuntos Académicos</a></li>
                                <li><a href="../oficinas/Academicos/Seguimiento al Egresado e Insercion Laboral/indexSegui.php">Seguimiento al Egresado e Inserción Laboral</a></li>
                                <li><a href="../oficinas/Academicos/TECNOLOGIAS DE LA INFORMACION/indexOTI.php">Tecnologías de la Información</a></li>
                                <li><a href="../oficinas/Academicos/INCUBADORA DE EMPRESAS/indexIncu.php">Incubadora de Empresas</a></li>
                                <li><a href="../oficinas/Academicos/FONDO EDITORIAL/indexFondo.php">Fondo Editorial</a></li>
                                <li><a href="../oficinas/Academicos/COMITE ELECTORAL UNIVERSITARIO/indexComite.php">Comité Electoral Universitario</a></li>
                                <li><a href="../oficinas/Academicos/INNOVACION Y TRANSFERENCIA TECNOLOGICA/indexInno.php">Innovación y Transferencia Tecnológica</a></li>
                                <li><a href="../oficinas/Academicos/PRODUCCION DE BIENES Y SERVICIOS/indexProdu.php">Producción de Bienes y Servicios</a></li>
                                <li><a href="../oficinas/Academicos/Responsabilidad Social Universitaria/indexRespon.php">Responsabilidad Social Universitaria</a></li>
                                <li><a href="../oficinas/Academicos/SERVICIOS GENERALES/indexServiGe.php">Servicios Generales</a></li>
                                <li><a href="../oficinas/Academicos/BIENESTAR UNIVERSITARIO/indexBienUni.php">Bienestar Universitario</a></li>
                                <li><a href="../oficinas/Academicos/DEFENSORIA UNIVERSITARIA/indexDefUni.php">Defensoría Universitaria</a></li>
                                <li><a href="../oficinas/Academicos/GESTION DE LA CALIDAD/indexGesCali.php">Gestión de la Calidad</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../admision/indexAdmin.php">ADMISIÓN</a></li>
                    <li><a href="#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menú Facultades">
                            <li class="has-submenu">
                                <a href="../facultades/ciencias agrarias/indexAgra.php" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../facultades/ciencias agrarias/agronomia/indexAgro.php">Agronomía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../facultades/ciencias de la salud/indexSalud.php" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="../facultades/ciencias de la salud/obstetricia/indexObst.php">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../facultades/medicina veterinaria/indexVet.php" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../facultades/medicina veterinaria/veterinaria/indexMedVet.php">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../facultades/Ingenieria Agroindustrial/indexIngAgroIndus.php" aria-haspopup="true" aria-expanded="false">Ingeniería Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Agroindustrial">
                                    <li><a href="../facultades/Ingenieria Agroindustrial/agroindustrias/indexAgroIn.php">Ingeniería Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../facultades/Ingenieria civil y arquitectura/indexCivArq.php" aria-haspopup="true" aria-expanded="false">Ingeniería Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Civil y Arquitectura">
                                    <li><a href="#arquitectura">Arquitectura</a></li>
                                    <li><a href="#ingenieria-civil-carrera">Ingeniería Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../facultades/Ingenieria de sistemas e informatica/indexFisi.php" aria-haspopup="true" aria-expanded="false">Ingeniería de Sistemas e Informática</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería de Sistemas">
                                    <li><a href="#ing-sistemas">Ingeniería de Sistemas e Informática</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../facultades/ecologia/indexEcolo.php" aria-haspopup="true" aria-expanded="false">Ecología</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecología">
                                    <li><a href="#ing-ambiental">Ingeniería Ambiental</a></li>
                                    <li><a href="#ing-sanitaria">Ingeniería Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../facultades/derecho y ciencias politicas/indexDerePoli.php" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Políticas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../facultades/medicina humana/indexMed.php" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="#medicina-humana-carrera">Medicina Humana</a></li>
                                    <li><a href="#enfermeria">Enfermería</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../facultades/ciencias economicas/indexCienEco.php" aria-haspopup="true" aria-expanded="false">Ciencias Económicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Económicas">
                                    <li><a href="#administracion">Administración</a></li>
                                    <li><a href="#contabilidad">Contabilidad</a></li>
                                    <li><a href="#economia">Economía</a></li>
                                    <li><a href="#turismo">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../facultades/educacion y humanidades/indexEdu.php" aria-haspopup="true" aria-expanded="false">Educación y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educación">
                                    <li><a href="../facultades/educacion y humanidades/indexEdu.php#educacion-inicial">Educación Inicial</a></li>
                                    <li><a href="../facultades/educacion y humanidades/indexEdu.php#educacion-primaria">Educación Primaria</a></li>
                                    <li><a href="../facultades/educacion y humanidades/indexEdu.php#educacion-secundaria">Educación Secundaria</a></li>
                                    <li><a href="../facultades/educacion y humanidades/indexEdu.php#idiomas">Idiomas</a></li>
                                    <li>
                                        <a href="../facultades/educacion y humanidades/psicologia/indexPsico.php">
                                            Psicología
                                            <span class="badge-nuevo">Nuevo</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Menú Transparencia">
                            <li><a href="#licenciamiento">Licenciamiento</a></li>
                            <li><a href="#institucional">Institucional Ley 30220</a></li>
                            <li><a href="#estandar">Estándar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>

                <!-- Logos gob.pe dentro del menú móvil -->
                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Perú">
                        <img src="../imagenes/logo gobPe.png" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.transparencia.gob.pe/enlaces/pte_transparencia_enlaces.aspx?id_entidad=10409" target="_blank" rel="noopener noreferrer">
                    <img src="../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer">
                    <img src="../imagenes/logo gobPe.png" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="noticias-hero">
        <h1>Noticias UNSM</h1>
        <p>Mantente informado sobre las últimas novedades de nuestra universidad</p>
    </section>

    <!-- Contenido Principal -->
    <main class="noticias-container">
        <?php
        $args = array(
            'post_type'      => 'post',
            'posts_per_page' => $posts_per_page,
            'paged'          => $paged,
            'orderby'        => 'date',
            'order'          => 'DESC',
            'post_status'    => 'publish'
        );

        $noticias_query = new WP_Query($args);
        $total_pages = $noticias_query->max_num_pages;

        if ($noticias_query->have_posts()) : ?>
            <div class="noticias-grid">
                <?php while ($noticias_query->have_posts()) : $noticias_query->the_post(); ?>
                    <article class="noticia-card">
                        <a href="<?php echo get_permalink(); ?>">
                            <div class="noticia-imagen">
                                <?php if (has_post_thumbnail()) : ?>
                                    <?php the_post_thumbnail('medium_large', array('alt' => get_the_title())); ?>
                                <?php else : ?>
                                    <img src="../imagenes/cuadros/investigacion.jpg" alt="<?php echo esc_attr(get_the_title()); ?>">
                                <?php endif; ?>
                                <?php
                                $categories = get_the_category();
                                if (!empty($categories)) : ?>
                                    <span class="noticia-categoria"><?php echo esc_html($categories[0]->name); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="noticia-contenido">
                                <time class="noticia-fecha" datetime="<?php echo get_the_date('c'); ?>">
                                    <?php echo get_the_date('d M Y'); ?>
                                </time>
                                <h2 class="noticia-titulo"><?php the_title(); ?></h2>
                                <p class="noticia-extracto">
                                    <?php echo wp_trim_words(get_the_excerpt(), 20, '...'); ?>
                                </p>
                                <span class="noticia-leer-mas">Leer más</span>
                            </div>
                        </a>
                    </article>
                <?php endwhile; ?>
            </div>

            <?php if ($total_pages > 1) : ?>
                <nav class="paginacion" aria-label="Paginación de noticias">
                    <?php if ($paged > 1) : ?>
                        <a href="?pag=<?php echo ($paged - 1); ?>" class="prev-next" aria-label="Página anterior">&laquo; Anterior</a>
                    <?php endif; ?>

                    <?php
                    $start = max(1, $paged - 2);
                    $end = min($total_pages, $paged + 2);

                    if ($start > 1) {
                        echo '<a href="?pag=1">1</a>';
                        if ($start > 2) echo '<span>...</span>';
                    }

                    for ($i = $start; $i <= $end; $i++) {
                        if ($i == $paged) {
                            echo '<span class="actual">' . $i . '</span>';
                        } else {
                            echo '<a href="?pag=' . $i . '">' . $i . '</a>';
                        }
                    }

                    if ($end < $total_pages) {
                        if ($end < $total_pages - 1) echo '<span>...</span>';
                        echo '<a href="?pag=' . $total_pages . '">' . $total_pages . '</a>';
                    }
                    ?>

                    <?php if ($paged < $total_pages) : ?>
                        <a href="?pag=<?php echo ($paged + 1); ?>" class="prev-next" aria-label="Página siguiente">Siguiente &raquo;</a>
                    <?php endif; ?>
                </nav>
            <?php endif; ?>

        <?php else : ?>
            <div class="no-noticias">
                <h2>No hay noticias disponibles</h2>
                <p>Pronto publicaremos nuevas noticias. ¡Vuelve pronto!</p>
                <a href="../index.php" class="btn-volver">Volver al inicio</a>
            </div>
        <?php endif; ?>

        <?php wp_reset_postdata(); ?>
    </main>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../imagenes/escudo unsm.png" alt="Escudo UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section">
                <h3 class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="../admision/indexAdmin.php">Admisión</a></li>
                    <li><a href="../index.php#facultades">Facultades</a></li>
                    <li><a href="../index.php#posgrado">Posgrado</a></li>
                    <li><a href="../index.php#investigacion">Investigación</a></li>
                </ul>
            </nav>

            <nav class="footer-section">
                <h3 class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="#">Biblioteca Virtual</a></li>
                    <li><a href="#">Campus Virtual</a></li>
                    <li><a href="#">Repositorio Institucional</a></li>
                    <li><a href="../contacto/indexContac.php">Contacto</a></li>
                </ul>
            </nav>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer">
                            <img src="../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu" target="_blank" rel="noopener noreferrer">
                            <img src="../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu" target="_blank" rel="noopener noreferrer">
                            <img src="../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer">
                            <img src="../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm" target="_blank" rel="noopener noreferrer">
                            <img src="../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <script src="../js/script.js" defer></script>
</body>
</html>
